/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.client;

import org.jetbrains.annotations.Nullable;

public final class ClientUtil {
    private ClientUtil() {
    }

    public static float[] parseHexColor(@Nullable String hex, double fallbackAlphaIfNoAA) {
        int r = 255;
        int g = 255;
        int b = 255;
        int a = (int)Math.round(fallbackAlphaIfNoAA * 255.0);
        if (hex != null) {
            String s = hex.trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            try {
                if (s.length() == 6) {
                    int rgb = Integer.parseInt(s, 16);
                    r = rgb >> 16 & 0xFF;
                    g = rgb >> 8 & 0xFF;
                    b = rgb & 0xFF;
                } else if (s.length() == 8) {
                    long rgba = Long.parseLong(s, 16);
                    r = (int)(rgba >> 24 & 0xFFL);
                    g = (int)(rgba >> 16 & 0xFFL);
                    b = (int)(rgba >> 8 & 0xFFL);
                    a = (int)(rgba & 0xFFL);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f};
    }
}

