/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.Uniform;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.tysontheember.orbitalrailgun.ForgeOrbitalRailgunMod;
import net.tysontheember.orbitalrailgun.client.OrbitalShaderUniforms;
import net.tysontheember.orbitalrailgun.client.railgun.RailgunState;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;
import net.tysontheember.orbitalrailgun.item.OrbitalRailgunItem;
import net.tysontheember.orbitalrailgun.network.C2S_RequestFire;
import net.tysontheember.orbitalrailgun.network.Network;
import net.tysontheember.orbitalrailgun.registry.ModSounds;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="orbital_railgun", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientEvents {
    private static final ResourceLocation RAILGUN_CHAIN_ID = ForgeOrbitalRailgunMod.id("shaders/post/railgun.json");
    private static final Field PASSES_FIELD = ClientEvents.findPassesField();
    private static final Set<ResourceLocation> MODEL_VIEW_UNIFORM_PASSES = Set.of(ForgeOrbitalRailgunMod.id("strike"), ForgeOrbitalRailgunMod.id("gui"), ForgeOrbitalRailgunMod.id("chromatic_abjuration"));
    private static PostChain railgunChain;
    private static boolean chainReady;
    private static int chainWidth;
    private static int chainHeight;
    private static boolean attackWasDown;
    private static boolean chargingLastTick;
    private static int prevSelectedSlot;
    private static Item prevMainHandItem;
    private static boolean pausedLatched;
    private static boolean latchedStrike;
    private static boolean latchedCharge;
    private static Vec3 latchedTargetPos;
    private static float latchedDistance;
    private static int latchedHitKind;
    private static float latchedTime;
    private static float lastVisibleEffectSeconds;
    private static boolean hudHiddenDuringCharge;
    private static boolean prevHideGuiValue;
    private static boolean haveIris;
    private static boolean lastShaderpackActive;

    private ClientEvents() {
    }

    private static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                if (ClientEvents.isShaderpackActive()) {
                    ClientEvents.closeChain();
                    ClientEvents.clearPauseLatch();
                    ForgeOrbitalRailgunMod.LOGGER.info("[orbital_railgun] Shaderpack active \u2014 skipping PostChain build on reload.");
                } else {
                    ClientEvents.reloadChain(resourceManager);
                    ClientEvents.clearPauseLatch();
                }
            }
        });
    }

    private static void clearPauseLatch() {
        pausedLatched = false;
        latchedStrike = false;
        latchedCharge = false;
        latchedTargetPos = Vec3.f_82478_;
        latchedDistance = 0.0f;
        latchedHitKind = 0;
        lastVisibleEffectSeconds = 0.0f;
        latchedTime = 0.0f;
    }

    private static void reloadChain(ResourceManager resourceManager) {
        if (ClientEvents.isShaderpackActive()) {
            ClientEvents.closeChain();
            chainReady = false;
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientEvents.closeChain();
        if (minecraft.m_91385_() == null) {
            chainReady = false;
            return;
        }
        try {
            railgunChain = new PostChain(minecraft.m_91097_(), resourceManager, minecraft.m_91385_(), RAILGUN_CHAIN_ID);
            chainReady = true;
            chainWidth = -1;
            chainHeight = -1;
            ClientEvents.resizeChain(minecraft);
            ForgeOrbitalRailgunMod.LOGGER.info("[orbital_railgun] Built PostChain (no shaderpack active).");
        }
        catch (IOException exception) {
            ForgeOrbitalRailgunMod.LOGGER.error("Failed to load orbital railgun post chain", (Throwable)exception);
            chainReady = false;
            ClientEvents.closeChain();
        }
    }

    private static void resizeChain(Minecraft minecraft) {
        if (railgunChain == null) {
            return;
        }
        RenderTarget mainTarget = minecraft.m_91385_();
        if (mainTarget == null) {
            return;
        }
        int width = mainTarget.f_83915_;
        int height = mainTarget.f_83916_;
        if (width == chainWidth && height == chainHeight) {
            return;
        }
        railgunChain.m_110025_(width, height);
        chainWidth = width;
        chainHeight = height;
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post event) {
        if (ClientEvents.isShaderpackActive()) {
            return;
        }
        if (!chainReady || railgunChain == null) {
            return;
        }
        ClientEvents.resizeChain(Minecraft.m_91087_());
    }

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent event) {
        float effectSeconds;
        int hitKindOrdinal;
        float distance;
        Vec3 targetPos;
        boolean renderStrike;
        float partial;
        if (ClientEvents.isShaderpackActive()) {
            return;
        }
        if (!chainReady || railgunChain == null) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        RailgunState state = RailgunState.getInstance();
        ClientLevel level = minecraft.f_91073_;
        boolean strikeActiveLive = state.isStrikeActive() && state.getStrikeDimension() != null && state.getStrikeDimension().equals((Object)level.m_46472_());
        boolean chargeActiveLive = state.isCharging();
        boolean anyActiveLive = strikeActiveLive || chargeActiveLive;
        ClientEvents.resizeChain(minecraft);
        boolean paused = minecraft.m_91104_();
        float f = partial = paused ? 0.0f : event.getPartialTick();
        if (paused && anyActiveLive && !pausedLatched) {
            float effectSecondsLive;
            pausedLatched = true;
            latchedStrike = strikeActiveLive;
            latchedCharge = chargeActiveLive;
            latchedTime = lastVisibleEffectSeconds = (effectSecondsLive = strikeActiveLive ? state.getStrikeSeconds(0.0f) : state.getChargeSeconds(0.0f));
            Vec3 liveTarget = strikeActiveLive ? state.getStrikePos() : state.getHitPos();
            latchedTargetPos = liveTarget == null ? Vec3.f_82478_ : liveTarget;
            Vec3 cam = event.getCamera().m_90583_();
            latchedDistance = (float)(latchedTargetPos == null ? 0.0 : cam.m_82554_(latchedTargetPos));
            latchedHitKind = state.getHitKind().ordinal();
        }
        if (paused && pausedLatched) {
            renderStrike = latchedStrike;
            boolean renderCharge = latchedCharge;
            targetPos = latchedTargetPos;
            distance = latchedDistance;
            hitKindOrdinal = latchedHitKind;
            effectSeconds = latchedTime;
        } else {
            if (!anyActiveLive) {
                if (!paused) {
                    ClientEvents.clearPauseLatch();
                }
                return;
            }
            renderStrike = strikeActiveLive;
            boolean renderCharge = chargeActiveLive;
            float f2 = effectSeconds = renderStrike ? state.getStrikeSeconds(partial) : state.getChargeSeconds(partial);
            if (!paused) {
                lastVisibleEffectSeconds = effectSeconds;
            }
            Vec3 vec3 = targetPos = renderStrike ? state.getStrikePos() : state.getHitPos();
            if (targetPos == null) {
                targetPos = Vec3.f_82478_;
            }
            Vec3 cam = event.getCamera().m_90583_();
            distance = (float)cam.m_82554_(targetPos);
            hitKindOrdinal = state.getHitKind().ordinal();
            if (!paused && pausedLatched) {
                ClientEvents.clearPauseLatch();
            }
        }
        Matrix4f projection = new Matrix4f((Matrix4fc)event.getProjectionMatrix());
        Matrix4f inverseProjection = new Matrix4f((Matrix4fc)projection).invert();
        Matrix4f modelView = new Matrix4f((Matrix4fc)event.getPoseStack().m_85850_().m_252922_());
        Vec3 cameraPos = event.getCamera().m_90583_();
        List<PostPass> passes = ClientEvents.getPasses();
        if (passes.isEmpty()) {
            if (!paused) {
                ClientEvents.clearPauseLatch();
            }
            return;
        }
        ClientEvents.applyUniforms(passes, modelView, projection, inverseProjection, cameraPos, targetPos, distance, effectSeconds, hitKindOrdinal != RailgunState.HitKind.NONE.ordinal() ? 1.0f : 0.0f, renderStrike, state, hitKindOrdinal);
        OrbitalShaderUniforms.applyColorUniforms(passes);
        railgunChain.m_110023_(partial);
        Minecraft.m_91087_().m_91385_().m_83947_(false);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean attackDown;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (ClientEvents.pollIrisStateChanged()) {
            if (ClientEvents.isShaderpackActive()) {
                ClientEvents.closeChain();
                ForgeOrbitalRailgunMod.LOGGER.info("[orbital_railgun] Shaderpack enabled \u2014 tearing down PostChain.");
            } else {
                ResourceManager rm = Minecraft.m_91087_().m_91098_();
                ClientEvents.reloadChain(rm);
                ForgeOrbitalRailgunMod.LOGGER.info("[orbital_railgun] Shaderpack disabled \u2014 rebuilding PostChain.");
            }
            ClientEvents.clearPauseLatch();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        RailgunState state = RailgunState.getInstance();
        state.tick(minecraft);
        ClientEvents.updateHudHiddenForCharge(minecraft, state);
        LocalPlayer player = minecraft.f_91074_;
        if (player != null) {
            int currentSlot = player.m_150109_().f_35977_;
            Item currentItem = player.m_21205_().m_41720_();
            if (prevSelectedSlot == -1) {
                prevSelectedSlot = currentSlot;
                prevMainHandItem = currentItem;
            } else {
                boolean itemChanged;
                boolean slotChanged = currentSlot != prevSelectedSlot;
                boolean bl = itemChanged = currentItem != prevMainHandItem;
                if ((slotChanged || itemChanged) && currentItem instanceof OrbitalRailgunItem && ModSounds.EQUIP.isPresent()) {
                    ClientEvents.playLocalPlayerSound((SoundEvent)ModSounds.EQUIP.get(), 1.0f, 1.0f);
                }
                prevSelectedSlot = currentSlot;
                prevMainHandItem = currentItem;
            }
        }
        ClientEvents.handleChargeAudio(state);
        boolean bl = attackDown = player != null && minecraft.f_91066_ != null && minecraft.f_91066_.f_92096_.m_90857_();
        if (attackDown && !attackWasDown && state.canRequestFire(player)) {
            ClientEvents.attemptFire(minecraft, state, player);
        }
        attackWasDown = attackDown;
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        Minecraft mc = Minecraft.m_91087_();
        if (hudHiddenDuringCharge) {
            mc.f_91066_.f_92062_ = prevHideGuiValue;
            hudHiddenDuringCharge = false;
        }
    }

    private static void attemptFire(Minecraft minecraft, RailgunState state, LocalPlayer player) {
        if (minecraft.f_91072_ == null) {
            return;
        }
        HitResult hitResult = state.getCurrentHit();
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos target = blockHitResult.m_82425_();
        OrbitalRailgunItem item = state.getActiveRailgunItem();
        if (item == null) {
            return;
        }
        item.applyCooldown((Player)player);
        minecraft.f_91072_.m_105277_((Player)player);
        state.markFired();
        Network.CHANNEL.sendToServer((Object)new C2S_RequestFire(target));
    }

    @SubscribeEvent
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        if (RailgunState.getInstance().isCharging()) {
            double baseFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
            event.setFOV(baseFov);
        }
    }

    private static void applyUniforms(List<PostPass> passes, Matrix4f modelView, Matrix4f projection, Matrix4f inverseProjection, Vec3 cameraPos, Vec3 targetPos, float distance, float timeSeconds, float isBlockHit, boolean strikeActive, RailgunState state, int hitKindOrdinal) {
        if (passes.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        RenderTarget renderTarget = minecraft.m_91385_();
        if (renderTarget == null) {
            return;
        }
        float width = renderTarget.f_83915_ > 0 ? (float)renderTarget.f_83915_ : (float)renderTarget.f_83917_;
        float height = renderTarget.f_83916_ > 0 ? (float)renderTarget.f_83916_ : (float)renderTarget.f_83918_;
        float strikeRadius = state.getTransientVisualStrikeRadius().orElse(Float.valueOf((float)((Double)OrbitalConfig.DESTRUCTION_DIAMETER.get() * 0.5))).floatValue();
        for (PostPass pass : passes) {
            EffectInstance effect = pass.m_110074_();
            if (effect == null) continue;
            ResourceLocation passName = ClientEvents.getPassName(pass);
            boolean expectsModelViewMatrix = passName != null && MODEL_VIEW_UNIFORM_PASSES.contains(passName);
            ClientEvents.setMatrix(effect, "ProjMat", projection);
            if (expectsModelViewMatrix) {
                ClientEvents.setMatrix(effect, "ModelViewMat", modelView);
            }
            ClientEvents.setMatrix(effect, "InverseTransformMatrix", inverseProjection);
            ClientEvents.setVec3(effect, "CameraPosition", cameraPos);
            ClientEvents.setVec3(effect, "BlockPosition", targetPos);
            ClientEvents.setVec3(effect, "HitPos", targetPos);
            ClientEvents.setVec2(effect, "OutSize", width, height);
            ClientEvents.setFloat(effect, "iTime", timeSeconds);
            ClientEvents.setFloat(effect, "Time", timeSeconds);
            ClientEvents.setFloat(effect, "GameTime", timeSeconds);
            ClientEvents.setFloat(effect, "iGlobalTime", timeSeconds);
            ClientEvents.setFloat(effect, "FrameTimeCounter", timeSeconds);
            ClientEvents.setFloat(effect, "Distance", distance);
            ClientEvents.setFloat(effect, "IsBlockHit", isBlockHit);
            ClientEvents.setFloat(effect, "StrikeActive", strikeActive ? 1.0f : 0.0f);
            ClientEvents.setFloat(effect, "SelectionActive", state.isCharging() ? 1.0f : 0.0f);
            ClientEvents.setInt(effect, "HitKind", hitKindOrdinal);
            ClientEvents.setFloat(effect, "StrikeRadius", strikeRadius);
        }
    }

    private static ResourceLocation getPassName(PostPass pass) {
        String name = pass.m_173046_();
        return name != null ? ResourceLocation.m_135820_((String)name) : null;
    }

    private static List<PostPass> getPasses() {
        if (railgunChain == null) {
            return Collections.emptyList();
        }
        if (PASSES_FIELD == null) {
            return Collections.emptyList();
        }
        try {
            Object value = PASSES_FIELD.get(railgunChain);
            if (value instanceof List) {
                List list;
                List passes = list = (List)value;
                return passes;
            }
            ForgeOrbitalRailgunMod.LOGGER.error("Orbital railgun post chain passes had unexpected type: {}", (Object)(value == null ? "null" : value.getClass().getName()));
        }
        catch (IllegalAccessException exception) {
            ForgeOrbitalRailgunMod.LOGGER.error("Failed to access orbital railgun post chain passes", (Throwable)exception);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static Field findPassesField() {
        try {
            return ObfuscationReflectionHelper.findField(PostChain.class, (String)"passes");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ignored) {
            try {
                return ObfuscationReflectionHelper.findField(PostChain.class, (String)"f_110009_");
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException exception) {
                ForgeOrbitalRailgunMod.LOGGER.error("Unable to find passes field on PostChain using Mojmap or SRG identifiers", (Throwable)exception);
                return null;
            }
        }
    }

    private static void setMatrix(EffectInstance effect, String name, Matrix4f matrix) {
        Uniform uniform = effect.m_108952_(name);
        if (uniform != null) {
            uniform.m_5679_(matrix);
        }
    }

    private static void setVec3(EffectInstance effect, String name, Vec3 vec) {
        Uniform uniform = effect.m_108952_(name);
        if (uniform != null) {
            uniform.m_5889_((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
        }
    }

    private static void setVec2(EffectInstance effect, String name, float x, float y) {
        Uniform uniform = effect.m_108952_(name);
        if (uniform != null) {
            uniform.m_7971_(x, y);
        }
    }

    private static void setFloat(EffectInstance effect, String name, float value) {
        Uniform uniform = effect.m_108952_(name);
        if (uniform != null) {
            uniform.m_5985_(value);
        }
    }

    private static void setInt(EffectInstance effect, String name, int value) {
        Uniform uniform = effect.m_108952_(name);
        if (uniform != null) {
            uniform.m_142617_(value);
        }
    }

    private static void closeChain() {
        if (railgunChain != null) {
            try {
                railgunChain.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            railgunChain = null;
        }
        chainReady = false;
        chainWidth = -1;
        chainHeight = -1;
    }

    private static void handleChargeAudio(RailgunState state) {
        boolean charging = state.isCharging();
        boolean wasCharging = chargingLastTick;
        if (charging && !wasCharging && ModSounds.SCOPE_ON.isPresent()) {
            ClientEvents.playLocalPlayerSound((SoundEvent)ModSounds.SCOPE_ON.get(), 1.0f, 1.0f);
        }
        chargingLastTick = charging;
    }

    private static void playLocalPlayerSound(SoundEvent sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        player.m_5496_(sound, volume, pitch);
    }

    private static void updateHudHiddenForCharge(Minecraft mc, RailgunState state) {
        boolean charging = state.isCharging();
        if (charging && !hudHiddenDuringCharge) {
            prevHideGuiValue = mc.f_91066_.f_92062_;
            mc.f_91066_.f_92062_ = true;
            hudHiddenDuringCharge = true;
        } else if (!charging && hudHiddenDuringCharge) {
            mc.f_91066_.f_92062_ = prevHideGuiValue;
            hudHiddenDuringCharge = false;
        }
        if (mc.f_91073_ == null && hudHiddenDuringCharge) {
            mc.f_91066_.f_92062_ = prevHideGuiValue;
            hudHiddenDuringCharge = false;
        }
    }

    private static boolean isShaderpackActive() {
        if (!haveIris) {
            return false;
        }
        return lastShaderpackActive;
    }

    private static boolean pollIrisStateChanged() {
        if (!haveIris) {
            return false;
        }
        boolean now = ClientEvents.queryIrisShaderpackInUse();
        boolean changed = now != lastShaderpackActive;
        lastShaderpackActive = now;
        return changed;
    }

    private static boolean queryIrisShaderpackInUse() {
        if (!haveIris) {
            return false;
        }
        try {
            Class<?> apiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object result = apiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(api, new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        chainWidth = -1;
        chainHeight = -1;
        prevSelectedSlot = -1;
        prevMainHandItem = null;
        pausedLatched = false;
        latchedStrike = false;
        latchedCharge = false;
        latchedTargetPos = Vec3.f_82478_;
        latchedDistance = 0.0f;
        latchedHitKind = 0;
        latchedTime = 0.0f;
        lastVisibleEffectSeconds = 0.0f;
        hudHiddenDuringCharge = false;
        prevHideGuiValue = false;
        haveIris = false;
        lastShaderpackActive = false;
        if (PASSES_FIELD != null) {
            PASSES_FIELD.setAccessible(true);
        } else {
            ForgeOrbitalRailgunMod.LOGGER.error("Failed to locate orbital railgun post chain passes field");
        }
        haveIris = ModList.get().isLoaded("oculus") || ModList.get().isLoaded("iris");
        lastShaderpackActive = ClientEvents.queryIrisShaderpackInUse();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::onRegisterReloadListeners);
    }
}

