/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.strike;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;
import net.tysontheember.orbitalrailgun.util.OrbitalRailgunStrikeManager;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="orbital_railgun", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class StrikeExecutor {
    private static final LongArrayFIFOQueue QUEUE = new LongArrayFIFOQueue();
    private static final LongOpenHashSet SEEN = new LongOpenHashSet();
    private static ServerLevel LEVEL;

    private StrikeExecutor() {
    }

    public static OrbitalRailgunStrikeManager.StrikeRequestResult queueStrike(ServerLevel level, BlockPos impactCenter, float power, int radius, @Nullable ServerPlayer requester) {
        double requestedRadius = Math.max(radius, 0);
        return OrbitalRailgunStrikeManager.requestStrike(level, impactCenter, requester, requestedRadius, power, true);
    }

    public static void begin(ServerLevel level, BlockPos impactCenter, double diameter) {
        int maxY;
        int topY;
        LEVEL = level;
        QUEUE.clear();
        SEEN.clear();
        double radius = Math.max(0.0, diameter * 0.5);
        int r = (int)Math.ceil(radius);
        int minY = level.m_141937_();
        for (int y = topY = (maxY = level.m_151558_() - 1); y >= minY; --y) {
            int baseX = impactCenter.m_123341_();
            int baseZ = impactCenter.m_123343_();
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    long key;
                    if (!((double)(dx * dx + dz * dz) <= radius * radius) || !SEEN.add(key = BlockPos.m_121882_((int)(baseX + dx), (int)y, (int)(baseZ + dz)))) continue;
                    QUEUE.enqueue(key);
                }
            }
        }
    }

    public static void filterAllowed(LongSet allowed) {
        if (LEVEL == null) {
            return;
        }
        LongArrayList ordered = new LongArrayList();
        while (!QUEUE.isEmpty()) {
            long key = QUEUE.dequeueLong();
            if (!allowed.contains(key)) continue;
            ordered.add(key);
        }
        QUEUE.clear();
        SEEN.clear();
        LongListIterator longListIterator = ordered.iterator();
        while (longListIterator.hasNext()) {
            long key = (Long)longListIterator.next();
            if (!SEEN.add(key)) continue;
            QUEUE.enqueue(key);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || LEVEL == null) {
            return;
        }
        if (QUEUE.isEmpty()) {
            LEVEL = null;
            return;
        }
        int budget = (Integer)OrbitalConfig.BLOCKS_PER_TICK.get();
        boolean drop = (Boolean)OrbitalConfig.DROP_BLOCKS.get();
        boolean allowUnbreakables = (Double)OrbitalConfig.MAX_BREAK_HARDNESS.get() < 0.0;
        for (int i = 0; i < budget && !QUEUE.isEmpty(); ++i) {
            BlockState state;
            long key = QUEUE.dequeueLong();
            BlockPos pos = BlockPos.m_122022_((long)key);
            if (!LEVEL.m_46749_(pos) || (state = LEVEL.m_8055_(pos)).m_60795_() || !allowUnbreakables && state.m_60800_((BlockGetter)LEVEL, pos) < 0.0f) continue;
            if (drop) {
                LEVEL.m_46953_(pos, true, null);
                continue;
            }
            LEVEL.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        }
    }
}

