/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.compat;

import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;
import xaero.pac.common.server.api.OpenPACServerAPI;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.protection.api.IChunkProtectionAPI;

public final class OPACGuard {
    private OPACGuard() {
    }

    public static boolean canBreakBlock(ServerLevel level, ServerPlayer shooter, BlockPos pos) {
        boolean allowInClaims = (Boolean)OrbitalConfig.ALLOW_BLOCK_BREAK_IN_CLAIMS.get();
        try {
            OpenPACServerAPI api = OpenPACServerAPI.get((MinecraftServer)level.m_7654_());
            if (api == null) {
                return true;
            }
            boolean claimed = OPACGuard.isBlockClaimed(api, level, pos);
            if (!allowInClaims && claimed) {
                return false;
            }
            IChunkProtectionAPI protection = api.getChunkProtection();
            if (protection == null) {
                return !claimed;
            }
            boolean protect = protection.onEntityPlaceBlock((Entity)shooter, level, pos);
            if (protect) {
                return false;
            }
            return allowInClaims || !claimed;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canDamageEntity(ServerLevel level, ServerPlayer shooter, Entity target) {
        boolean allowInClaims = (Boolean)OrbitalConfig.ALLOW_ENTITY_DAMAGE_IN_CLAIMS.get();
        try {
            OpenPACServerAPI api = OpenPACServerAPI.get((MinecraftServer)level.m_7654_());
            if (api == null) {
                return true;
            }
            boolean claimed = OPACGuard.isBlockClaimed(api, level, target.m_20183_());
            if (!allowInClaims && claimed) {
                return false;
            }
            IChunkProtectionAPI protection = api.getChunkProtection();
            if (protection == null) {
                return !claimed;
            }
            boolean protect = protection.onEntityInteraction((Entity)shooter, (Entity)shooter, target, shooter.m_21205_(), InteractionHand.MAIN_HAND, true, false, true);
            if (protect) {
                return false;
            }
            return allowInClaims || !claimed;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canAffectPosFromPos(ServerLevel fromLevel, ChunkPos fromChunk, ServerLevel toLevel, ChunkPos toChunk) {
        boolean allowInClaims = (Boolean)OrbitalConfig.ALLOW_EXPLOSIONS_IN_CLAIMS.get();
        try {
            OpenPACServerAPI api = OpenPACServerAPI.get((MinecraftServer)fromLevel.m_7654_());
            if (api == null) {
                return true;
            }
            boolean claimed = OPACGuard.isChunkClaimed(api, toLevel, toChunk);
            if (!allowInClaims && claimed) {
                return false;
            }
            IChunkProtectionAPI protection = api.getChunkProtection();
            if (protection == null) {
                return !claimed;
            }
            boolean protect = protection.onPosAffectedByAnotherPos(toLevel, toChunk, fromLevel, fromChunk, true, true, true);
            if (protect) {
                return false;
            }
            return allowInClaims || !claimed;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static boolean isBlockClaimed(OpenPACServerAPI api, ServerLevel level, BlockPos pos) {
        IServerClaimsManagerAPI claims = api.getServerClaimsManager();
        if (claims == null) {
            return false;
        }
        return claims.get(level.m_46472_().m_135782_(), pos) != null;
    }

    private static boolean isChunkClaimed(OpenPACServerAPI api, ServerLevel level, ChunkPos chunk) {
        IServerClaimsManagerAPI claims = api.getServerClaimsManager();
        if (claims == null) {
            return false;
        }
        return claims.get(level.m_46472_().m_135782_(), chunk) != null;
    }
}

