/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.compat;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.tysontheember.orbitalrailgun.compat.ClaimCompat;
import net.tysontheember.orbitalrailgun.compat.FTBGuard;
import net.tysontheember.orbitalrailgun.compat.OPACGuard;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;

public final class ClaimGuards {
    private ClaimGuards() {
    }

    public static boolean canBreakBlock(ServerLevel level, ServerPlayer shooter, BlockPos pos) {
        boolean ftb = ClaimGuards.shouldCheckFTB();
        boolean opac = ClaimGuards.shouldCheckOPAC();
        if (!ftb && !opac) {
            return true;
        }
        if (shooter == null) {
            return false;
        }
        if (((Boolean)OrbitalConfig.OPS_BYPASS_CLAIMS.get()).booleanValue() && shooter.m_20310_(2)) {
            return true;
        }
        boolean allowed = true;
        if (ftb) {
            allowed &= FTBGuard.canBreakBlock(level, shooter, pos);
        }
        if (allowed && opac) {
            allowed &= OPACGuard.canBreakBlock(level, shooter, pos);
        }
        return allowed;
    }

    public static boolean canDamageEntity(ServerLevel level, ServerPlayer shooter, Entity target) {
        boolean ftb = ClaimGuards.shouldCheckFTB();
        boolean opac = ClaimGuards.shouldCheckOPAC();
        if (!ftb && !opac) {
            return true;
        }
        if (shooter == null) {
            return false;
        }
        if (((Boolean)OrbitalConfig.OPS_BYPASS_CLAIMS.get()).booleanValue() && shooter.m_20310_(2)) {
            return true;
        }
        boolean allowed = true;
        if (ftb) {
            allowed &= FTBGuard.canDamageEntity(level, shooter, target);
        }
        if (allowed && opac) {
            allowed &= OPACGuard.canDamageEntity(level, shooter, target);
        }
        return allowed;
    }

    public static boolean canAffectPosFromPos(ServerLevel fromLevel, BlockPos fromPos, ServerLevel toLevel, BlockPos toPos, ServerPlayer shooter) {
        boolean ftb = ClaimGuards.shouldCheckFTB();
        boolean opac = ClaimGuards.shouldCheckOPAC();
        if (!ftb && !opac) {
            return true;
        }
        if (shooter == null && (ftb || opac)) {
            return false;
        }
        if (shooter != null && ((Boolean)OrbitalConfig.OPS_BYPASS_CLAIMS.get()).booleanValue() && shooter.m_20310_(2)) {
            return true;
        }
        boolean allowed = true;
        if (ftb) {
            allowed &= FTBGuard.canAffectPosFromPos(toLevel, toPos, shooter);
        }
        if (allowed && opac) {
            ChunkPos fromChunk = new ChunkPos(fromPos);
            ChunkPos toChunk = new ChunkPos(toPos);
            allowed &= OPACGuard.canAffectPosFromPos(fromLevel, fromChunk, toLevel, toChunk);
        }
        return allowed;
    }

    private static boolean shouldCheckFTB() {
        return ClaimCompat.hasFTB() && (Boolean)OrbitalConfig.RESPECT_CLAIMS.get() != false;
    }

    private static boolean shouldCheckOPAC() {
        return ClaimCompat.hasOPAC() && (Boolean)OrbitalConfig.RESPECT_OPAC_CLAIMS.get() != false;
    }
}

