/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import de.schlichtherle.xml.GenericCertificateIntegrityException;
import de.schlichtherle.xml.GenericCertificateIsLockedException;
import de.schlichtherle.xml.GenericCertificateNotLockedException;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import de.schlichtherle.xml.XMLConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public final class GenericCertificate
implements Serializable,
XMLConstants {
    private static final long serialVersionUID = 6247620498526484734L;
    private static final String BASE64_CHARSET = "US-ASCII";
    private static final String SIGNATURE_ENCODING = "US-ASCII/Base64";
    private volatile transient boolean locked;
    private String encoded;
    private String signature;
    private String signatureAlgorithm;
    private String signatureEncoding;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient VetoableChangeSupport vetoableChangeSupport;

    public GenericCertificate() {
    }

    public GenericCertificate(GenericCertificate cert) {
        try {
            this.setEncoded(cert.getEncoded());
            this.setSignature(cert.getSignature());
            this.setSignatureAlgorithm(cert.getSignatureAlgorithm());
            this.setSignatureEncoding(cert.getSignatureEncoding());
        }
        catch (PropertyVetoException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public synchronized void sign(Object content, PrivateKey signingKey, Signature signingEngine) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, PersistenceServiceException, InvalidKeyException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "locked", this.locked, Boolean.TRUE);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (null == signingKey || null == signingEngine) {
            throw new NullPointerException();
        }
        this.fireVetoableChange(evt);
        try {
            byte[] beo = PersistenceService.store2ByteArray((Object)content);
            String encoded = new String(beo, "UTF-8");
            signingEngine.initSign(signingKey);
            signingEngine.update(beo);
            byte[] b64es = Base64.encodeBase64((byte[])signingEngine.sign());
            String signature = new String(b64es, BASE64_CHARSET);
            String algorithm = signingEngine.getAlgorithm();
            this.setEncoded(encoded);
            this.setSignature(signature);
            this.setSignatureAlgorithm(algorithm);
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (SignatureException ex) {
            throw new AssertionError((Object)ex);
        }
        this.locked = true;
        this.firePropertyChange(evt);
    }

    public synchronized void verify(PublicKey verificationKey, Signature verificationEngine) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, InvalidKeyException, SignatureException, GenericCertificateIntegrityException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "locked", this.locked, Boolean.TRUE);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (null == verificationKey || null == verificationEngine) {
            throw new NullPointerException();
        }
        this.fireVetoableChange(evt);
        try {
            byte[] beo = this.encoded.getBytes("UTF-8");
            verificationEngine.initVerify(verificationKey);
            verificationEngine.update(beo);
            byte[] b64ds = Base64.decodeBase64((byte[])this.signature.getBytes(BASE64_CHARSET));
            String algorithm = verificationEngine.getAlgorithm();
            this.setSignatureAlgorithm(algorithm);
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        this.locked = true;
        this.firePropertyChange(evt);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized Object getContent() throws GenericCertificateNotLockedException, PersistenceServiceException {
        if (!this.locked) {
            throw new GenericCertificateNotLockedException();
        }
        return PersistenceService.load((String)this.encoded);
    }

    public synchronized String getEncoded() {
        return this.encoded;
    }

    public synchronized void setEncoded(String encoded) throws GenericCertificateIsLockedException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "encoded", this.encoded, encoded);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (GenericCertificate.equals(this.encoded, encoded)) {
            return;
        }
        this.encoded = encoded;
        this.firePropertyChange(evt);
    }

    public synchronized String getSignature() {
        return this.signature;
    }

    public synchronized void setSignature(String signature) throws GenericCertificateIsLockedException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signature", this.signature, signature);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (GenericCertificate.equals(this.signature, signature)) {
            return;
        }
        this.signature = signature;
        this.firePropertyChange(evt);
    }

    public synchronized String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public synchronized void setSignatureAlgorithm(String signatureAlgorithm) throws GenericCertificateIsLockedException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signatureAlgorithm", this.signatureAlgorithm, signatureAlgorithm);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (GenericCertificate.equals(this.signatureAlgorithm, signatureAlgorithm)) {
            return;
        }
        this.signatureAlgorithm = signatureAlgorithm;
        this.firePropertyChange(evt);
    }

    public synchronized String getSignatureEncoding() {
        return this.signatureEncoding;
    }

    public synchronized void setSignatureEncoding(String signatureEncoding) throws GenericCertificateIsLockedException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "signatureEncoding", this.signatureEncoding, signatureEncoding);
        if (this.locked) {
            throw new GenericCertificateIsLockedException(evt);
        }
        if (GenericCertificate.equals(this.signatureEncoding, signatureEncoding)) {
            return;
        }
        this.signatureEncoding = signatureEncoding;
        this.firePropertyChange(evt);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || null != a && a.equals(b);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (null == this.vetoableChangeSupport) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        if (null == this.vetoableChangeSupport) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    private void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (null == this.vetoableChangeSupport) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(evt);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propertyChangeSupport) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propertyChangeSupport) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        if (null == this.propertyChangeSupport) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(evt);
    }
}

