/*
 * Decompiled with CFR 0.152.
 */
package cpislicense.client.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SystemInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoUtil.class);
    @Value(value="${spring.application.name}")
    private String microServiceName = "";
    @Value(value="${server.port}")
    private String microServicePort = "";
    @Value(value="${cpis.license.report:true}")
    private Boolean reportFlag;
    private Set<String> ipAddress = new HashSet<String>();
    private Set<String> macAddress = new HashSet<String>();
    private String CPUSerial = "";
    private String motherboardSN = "";
    private String hardDiskSN = "";
    private boolean initOK = false;

    public void initSystemInfo() {
        this.initIpAddress();
        this.initOK = true;
    }

    private void initIpAddress() {
        HashSet<String> ipAddress = new HashSet<String>();
        if (this.isWindowsOS()) {
            try {
                ipAddress.add(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38", (Throwable)e);
            }
        } else {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    Enumeration<InetAddress> nias = ni.getInetAddresses();
                    while (nias.hasMoreElements()) {
                        InetAddress ia = nias.nextElement();
                        if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                        ipAddress.add(ia.getHostAddress());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38", (Throwable)e);
            }
        }
        this.setIpAddress(ipAddress);
    }

    private void initMacAddress() {
        HashSet<String> macAddress = new HashSet<String>();
        if (this.isWindowsOS()) {
            try {
                byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                if (mac != null) {
                    for (int i = 0; i < mac.length; ++i) {
                        int temp;
                        String str;
                        if (i != 0) {
                            sb.append("-");
                        }
                        if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                            sb.append("0").append(str);
                            continue;
                        }
                        sb.append(str);
                    }
                }
                macAddress.add(sb.toString().toUpperCase());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6Mac\u5730\u5740\u5f02\u5e38", (Throwable)e);
            }
        } else {
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                StringBuilder sb = new StringBuilder();
                while (en.hasMoreElements()) {
                    NetworkInterface iface = en.nextElement();
                    List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
                    for (InterfaceAddress addr : addrs) {
                        byte[] mac;
                        InetAddress ip = addr.getAddress();
                        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                        if (network == null || (mac = network.getHardwareAddress()) == null) continue;
                        sb.delete(0, sb.length());
                        for (int i = 0; i < mac.length; ++i) {
                            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                        }
                        macAddress.add(sb.toString());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6Mac\u5730\u5740\u5f02\u5e38", (Throwable)e);
            }
        }
        this.setMacAddress(macAddress);
    }

    private void initCPUSerial() {
        String CPUSerial = "";
        if (this.isWindowsOS()) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
                process.getOutputStream().close();
                Scanner sc = new Scanner(process.getInputStream());
                sc.next();
                CPUSerial = sc.next();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6CPU\u5e8f\u5217\u53f7\u5f02\u5e38", (Throwable)e);
            }
        } else {
            try {
                String line;
                Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "dmidecode"});
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    int index = line.toLowerCase().indexOf("uuid");
                    if (index < 0) continue;
                    CPUSerial = line.substring(index + "uuid".length() + 1).trim();
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6CPU\u5e8f\u5217\u53f7\u5f02\u5e38", (Throwable)e);
            }
        }
        this.setCPUSerial(CPUSerial);
    }

    private void initMotherboardSN() {
        if (this.isWindowsOS()) {
            try {
                String line;
                StringBuilder result = new StringBuilder();
                File file = File.createTempFile("realhowto", ".vbs");
                file.deleteOnExit();
                FileWriter fw = new FileWriter(file);
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
                fw.write(vbs);
                fw.close();
                String path = file.getPath().replace("%20", " ");
                Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    result.append(line);
                }
                input.close();
                this.motherboardSN = result.toString().trim();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e3b\u677f\u5e8f\u5217\u53f7\u5f02\u5e38", (Throwable)e);
            }
        } else {
            try {
                String result = "";
                String maniBord_cmd = "dmidecode | grep 'Serial Number' | awk '{print $3}' | tail -1";
                Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", maniBord_cmd});
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = br.readLine();
                if (line != null) {
                    result = result + line;
                }
                br.close();
                this.motherboardSN = result;
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u4e3b\u677f\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            }
        }
        this.setMotherboardSN(this.motherboardSN);
    }

    private void initHardDiskSN() {
        String hardDiskSN = "";
        if (this.isWindowsOS()) {
            try {
                String line;
                String HdSerial = "";
                Process proces = Runtime.getRuntime().exec("cmd /c dir c:");
                BufferedReader buffreader = new BufferedReader(new InputStreamReader(proces.getInputStream(), "gbk"));
                while ((line = buffreader.readLine()) != null) {
                    if (!line.contains("\u5377\u7684\u5e8f\u5217\u53f7\u662f ")) continue;
                    HdSerial = line.substring(line.indexOf("\u5377\u7684\u5e8f\u5217\u53f7\u662f ") + "\u5377\u7684\u5e8f\u5217\u53f7\u662f ".length());
                    break;
                }
                hardDiskSN = HdSerial;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7\u5f02\u5e38", (Throwable)e);
            }
        } else {
            hardDiskSN = "";
        }
        this.setHardDiskSN(hardDiskSN);
    }

    private boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().contains("windows")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public void printSystemInfo() {
        if (!this.initOK) {
            this.initSystemInfo();
        }
        log.info("---------------\u672c\u673a\u4fe1\u606fstart---------------");
        log.info("IpAddress:" + this.getIpAddress());
        log.info("MacAddress:" + this.getMacAddress());
        log.info("CPUSerial:" + this.getCPUSerial());
        log.info("MotherboardSN:" + this.getMotherboardSN());
        log.info("HardDiskSN:" + this.getHardDiskSN());
        log.info("MicroServiceName:" + this.getMicroServiceName());
        log.info("----------------\u672c\u673a\u4fe1\u606fend----------------");
    }

    public String getMicroServiceName() {
        return this.microServiceName;
    }

    public String getMicroServicePort() {
        return this.microServicePort;
    }

    public Boolean getReportFlag() {
        return this.reportFlag;
    }

    public Set<String> getIpAddress() {
        return this.ipAddress;
    }

    public Set<String> getMacAddress() {
        return this.macAddress;
    }

    public String getCPUSerial() {
        return this.CPUSerial;
    }

    public String getMotherboardSN() {
        return this.motherboardSN;
    }

    public String getHardDiskSN() {
        return this.hardDiskSN;
    }

    public boolean isInitOK() {
        return this.initOK;
    }

    public void setMicroServiceName(String microServiceName) {
        this.microServiceName = microServiceName;
    }

    public void setMicroServicePort(String microServicePort) {
        this.microServicePort = microServicePort;
    }

    public void setReportFlag(Boolean reportFlag) {
        this.reportFlag = reportFlag;
    }

    public void setIpAddress(Set<String> ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setMacAddress(Set<String> macAddress) {
        this.macAddress = macAddress;
    }

    public void setCPUSerial(String CPUSerial) {
        this.CPUSerial = CPUSerial;
    }

    public void setMotherboardSN(String motherboardSN) {
        this.motherboardSN = motherboardSN;
    }

    public void setHardDiskSN(String hardDiskSN) {
        this.hardDiskSN = hardDiskSN;
    }

    public void setInitOK(boolean initOK) {
        this.initOK = initOK;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemInfoUtil)) {
            return false;
        }
        SystemInfoUtil other = (SystemInfoUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$microServiceName = this.getMicroServiceName();
        String other$microServiceName = other.getMicroServiceName();
        if (this$microServiceName == null ? other$microServiceName != null : !this$microServiceName.equals(other$microServiceName)) {
            return false;
        }
        String this$microServicePort = this.getMicroServicePort();
        String other$microServicePort = other.getMicroServicePort();
        if (this$microServicePort == null ? other$microServicePort != null : !this$microServicePort.equals(other$microServicePort)) {
            return false;
        }
        Boolean this$reportFlag = this.getReportFlag();
        Boolean other$reportFlag = other.getReportFlag();
        if (this$reportFlag == null ? other$reportFlag != null : !((Object)this$reportFlag).equals(other$reportFlag)) {
            return false;
        }
        Set<String> this$ipAddress = this.getIpAddress();
        Set<String> other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !((Object)this$ipAddress).equals(other$ipAddress)) {
            return false;
        }
        Set<String> this$macAddress = this.getMacAddress();
        Set<String> other$macAddress = other.getMacAddress();
        if (this$macAddress == null ? other$macAddress != null : !((Object)this$macAddress).equals(other$macAddress)) {
            return false;
        }
        String this$CPUSerial = this.getCPUSerial();
        String other$CPUSerial = other.getCPUSerial();
        if (this$CPUSerial == null ? other$CPUSerial != null : !this$CPUSerial.equals(other$CPUSerial)) {
            return false;
        }
        String this$motherboardSN = this.getMotherboardSN();
        String other$motherboardSN = other.getMotherboardSN();
        if (this$motherboardSN == null ? other$motherboardSN != null : !this$motherboardSN.equals(other$motherboardSN)) {
            return false;
        }
        String this$hardDiskSN = this.getHardDiskSN();
        String other$hardDiskSN = other.getHardDiskSN();
        if (this$hardDiskSN == null ? other$hardDiskSN != null : !this$hardDiskSN.equals(other$hardDiskSN)) {
            return false;
        }
        return this.isInitOK() == other.isInitOK();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemInfoUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $microServiceName = this.getMicroServiceName();
        result = result * 59 + ($microServiceName == null ? 43 : $microServiceName.hashCode());
        String $microServicePort = this.getMicroServicePort();
        result = result * 59 + ($microServicePort == null ? 43 : $microServicePort.hashCode());
        Boolean $reportFlag = this.getReportFlag();
        result = result * 59 + ($reportFlag == null ? 43 : ((Object)$reportFlag).hashCode());
        Set<String> $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : ((Object)$ipAddress).hashCode());
        Set<String> $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : ((Object)$macAddress).hashCode());
        String $CPUSerial = this.getCPUSerial();
        result = result * 59 + ($CPUSerial == null ? 43 : $CPUSerial.hashCode());
        String $motherboardSN = this.getMotherboardSN();
        result = result * 59 + ($motherboardSN == null ? 43 : $motherboardSN.hashCode());
        String $hardDiskSN = this.getHardDiskSN();
        result = result * 59 + ($hardDiskSN == null ? 43 : $hardDiskSN.hashCode());
        result = result * 59 + (this.isInitOK() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SystemInfoUtil(microServiceName=" + this.getMicroServiceName() + ", microServicePort=" + this.getMicroServicePort() + ", reportFlag=" + this.getReportFlag() + ", ipAddress=" + this.getIpAddress() + ", macAddress=" + this.getMacAddress() + ", CPUSerial=" + this.getCPUSerial() + ", motherboardSN=" + this.getMotherboardSN() + ", hardDiskSN=" + this.getHardDiskSN() + ", initOK=" + this.isInitOK() + ")";
    }
}

