/*
 * Decompiled with CFR 0.152.
 */
package cpislicense.client.programme.time.interceptor;

import cpislicense.client.manager.ClientLicenseManager;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
@ConditionalOnProperty(prefix="cpislicense.client", name={"cron"})
public class LicenseInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LicenseInterceptor.class);
    @Resource
    ClientLicenseManager clientLicenseManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Boolean licenseState = this.clientLicenseManager.getLicenseState();
        if (licenseState.booleanValue()) {
            return true;
        }
        int licenseCode = this.clientLicenseManager.getLicenseCode();
        String msg = this.clientLicenseManager.getLicenseMsg();
        log.error("license\u6388\u6743\u6587\u4ef6\u8fc7\u671f\uff0c\u9519\u8bef\u7801\uff1a(" + licenseCode + ")");
        response.getWriter().write(msg);
        response.setStatus(licenseCode);
        return false;
    }
}

