/*
 * Decompiled with CFR 0.152.
 */
package cpislicense.client.programme.time.filter;

import com.alibaba.fastjson.JSONObject;
import cpislicense.client.manager.ClientLicenseManager;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=10)
@WebFilter(filterName="licenseFilter", urlPatterns={"/*"})
@Component
@Configuration
public class LicenseFilter
implements Filter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(LicenseFilter.class);
    @Resource
    ClientLicenseManager clientLicenseManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("licenseFilter initial.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Boolean licenseState = this.clientLicenseManager.getLicenseState();
        if (licenseState.booleanValue()) {
            chain.doFilter(request, response);
        } else {
            int licenseCode = this.clientLicenseManager.getLicenseCode();
            String msg = this.clientLicenseManager.getLicenseMsg();
            JSONObject reslut = new JSONObject();
            reslut.put("code", (Object)licenseCode);
            reslut.put("msg", (Object)msg);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().print(reslut);
            response.getWriter().flush();
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return 10;
    }
}

