/*
 * Decompiled with CFR 0.152.
 */
package cpislicense.client.manager;

import com.lc.ibps.cloud.redis.utils.RedisUtil;
import cpislicense.client.pojo.ClientLicenseParam;
import cpislicense.client.pojo.ClientProperties;
import cpislicense.client.util.EnumVal;
import cpislicense.client.util.Md5Util;
import cpislicense.client.util.SystemInfoUtil;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ClientLicenseManager
extends LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(ClientLicenseManager.class);
    @Resource
    private ClientLicenseParam clientLicenseParam;
    @Resource
    private SystemInfoUtil systemInfoUtil;
    @Resource
    private ClientProperties clientProperties;
    private LicenseContent licenseContent;
    private Boolean licenseState = false;
    private int licenseCode = EnumVal.LICENSE_ERROR.getCode();
    private String licenseMsg = EnumVal.LICENSE_ERROR.getMsg();

    public boolean installAndCheck() {
        boolean installSuccess = this.install();
        if (!installSuccess) {
            return false;
        }
        return this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install() {
        try {
            ClientLicenseManager clientLicenseManager = this;
            synchronized (clientLicenseManager) {
                log.info("\u5f00\u59cb\u5b89\u88c5\u5ba2\u6237\u7aef\u8bc1\u4e66!");
                this.setLicenseParam(this.clientLicenseParam);
                File file = new File(this.clientProperties.getLicPath());
                System.out.println("file=>" + file.getPath());
                this.licenseContent = this.install(file);
                log.info("\u5ba2\u6237\u7aef\u8bc1\u4e66\u5b89\u88c5\u6210\u529f!" + file);
            }
        }
        catch (Exception e) {
            this.licenseState = false;
            this.licenseCode = EnumVal.LICENSE_FILE_ERROR.getCode();
            this.licenseMsg = EnumVal.LICENSE_FILE_ERROR.getMsg();
            log.error(EnumVal.LICENSE_FILE_ERROR.getMsg());
            log.error(EnumVal.LICENSE_FILE_ERROR.getMsg());
            log.error(EnumVal.LICENSE_FILE_ERROR.getMsg());
            log.error(EnumVal.LICENSE_FILE_ERROR.getMsg());
            log.error("\u5ba2\u6237\u7aef\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25!" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
            return false;
        }
        return true;
    }

    public boolean check() {
        String md5CodeStr;
        String microServiceName;
        Set<String> ipAddressSet;
        HashMap extra;
        String ipAddress;
        boolean installSuccess;
        if (this.licenseContent == null && !(installSuccess = this.install())) {
            return false;
        }
        boolean isOk = true;
        Date dateNow = new Date();
        Date notBefore = this.licenseContent.getNotBefore();
        if (dateNow.getTime() <= notBefore.getTime()) {
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            this.licenseCode = EnumVal.TIME_EXPIRE.getCode();
            this.licenseMsg = EnumVal.TIME_EXPIRE.getMsg();
            isOk = false;
        }
        Date notAfter = this.licenseContent.getNotAfter();
        if (dateNow.getTime() >= notAfter.getTime()) {
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u6388\u6743\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            this.licenseCode = EnumVal.TIME_EXPIRE.getCode();
            this.licenseMsg = EnumVal.TIME_EXPIRE.getMsg();
            isOk = false;
        }
        if (StringUtils.hasText((String)(ipAddress = (String)(extra = (HashMap)this.licenseContent.getExtra()).get("ipAddress"))) && !(ipAddressSet = this.systemInfoUtil.getIpAddress()).contains(ipAddress)) {
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(IP\u5730\u5740)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(IP\u5730\u5740)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(IP\u5730\u5740)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(IP\u5730\u5740)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(IP\u5730\u5740)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            this.licenseCode = EnumVal.IP_ADDRESS_ERROR.getCode();
            this.licenseMsg = EnumVal.IP_ADDRESS_ERROR.getMsg();
            isOk = false;
        }
        if (StringUtils.hasText((String)(microServiceName = (String)extra.get("microServiceName")))) {
            String serverNameLocal = this.systemInfoUtil.getMicroServiceName();
            if (microServiceName.indexOf(",") != -1) {
                String[] serviceNameArr = microServiceName.split(",");
                isOk = false;
                int sizei = serviceNameArr.length;
                for (int i = 0; i < sizei; ++i) {
                    String serviceNameStr = serviceNameArr[i].replaceAll("\uff0c", ",").trim();
                    if (!serverNameLocal.equals(serviceNameStr)) continue;
                    isOk = true;
                    break;
                }
                if (!isOk) {
                    log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                    log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                    log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                    log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                    log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                    this.licenseCode = EnumVal.SERVICE_NAME_ERROR.getCode();
                    this.licenseMsg = EnumVal.SERVICE_NAME_ERROR.getMsg();
                }
            } else if (microServiceName.equals(serverNameLocal)) {
                log.info("\u9a8c\u8bc1\u901a\u8fc7:{}\u5fae\u670d\u52a1\u540d", (Object)serverNameLocal);
            } else {
                log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                log.error("\u9a8c\u8bc1\u5931\u8d25:{}\u670d\u52a1\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01", (Object)serverNameLocal);
                this.licenseCode = EnumVal.SERVICE_NAME_ERROR.getCode();
                this.licenseMsg = EnumVal.SERVICE_NAME_ERROR.getMsg();
                isOk = false;
            }
        }
        if (StringUtils.hasLength((String)(md5CodeStr = (String)extra.get("md5Code")))) {
            if (!md5CodeStr.equals(Md5Util.Md5())) {
                log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                this.licenseCode = EnumVal.MACHINE_CODE_ERROR.getCode();
                this.licenseMsg = EnumVal.MACHINE_CODE_ERROR.getMsg();
                isOk = false;
            }
        } else {
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            log.error("\u9a8c\u8bc1\u5931\u8d25:\u4e3b\u673a(\u673a\u5668\u7801)\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            this.licenseCode = EnumVal.MACHINE_CODE_ERROR.getCode();
            this.licenseMsg = EnumVal.MACHINE_CODE_ERROR.getMsg();
            isOk = false;
        }
        if (isOk) {
            log.info("\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u6210\u529f!!!");
        } else {
            log.error("\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25!!!");
        }
        this.licenseState = isOk;
        return isOk;
    }

    public void saveLicenseInfoToRedis() {
        String serverNameLocal = this.systemInfoUtil.getMicroServiceName();
        String equipmentNo = Md5Util.Md5();
        String ip = String.valueOf(this.systemInfoUtil.getIpAddress());
        String serverPortLocal = this.systemInfoUtil.getMicroServicePort();
        String mapKey = "licenseInfo:" + serverNameLocal + "#" + equipmentNo + "#" + ip + "#" + serverPortLocal;
        HashMap<String, Date> map = new HashMap<String, Date>();
        Date notBefore = this.licenseContent.getNotBefore();
        Date notAfter = this.licenseContent.getNotAfter();
        map.put("startTime", notBefore);
        map.put("endTime", notAfter);
        RedisUtil.redisTemplate.opsForValue().set((Object)mapKey, (Object)map, 72L, TimeUnit.HOURS);
    }

    public Boolean getLicenseState() {
        return this.licenseState;
    }

    public int getLicenseCode() {
        return this.licenseCode;
    }

    public String getLicenseMsg() {
        return this.licenseMsg;
    }

    public LicenseContent getLicenseContent() {
        return this.licenseContent;
    }
}

