/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.redis.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.cpis.fegin.FeginExtendService;
import com.cpis.fegin.FeginOauthService;
import com.cpis.redis.po.CpisUserPo;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.cloud.entity.APIResult;
import com.lc.ibps.cloud.redis.utils.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CpisRedisUtil {
    private static FeginExtendService feginExtendService;
    private static FeginOauthService feginOauthService;
    @Resource
    private FeginExtendService feginExtendServiceTemp;
    @Resource
    private FeginOauthService feginOauthServiceTemp;

    @PostConstruct
    public void init() {
        feginExtendService = this.feginExtendServiceTemp;
        feginOauthService = this.feginOauthServiceTemp;
    }

    public static CpisUserPo getCpisUserById(String id) {
        CpisUserPo userPo = new CpisUserPo();
        if (RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList") == null) {
            Map cpisUserListMap;
            Map cpisUserMap;
            APIResult<Boolean> result = feginExtendService.getCpisUserList();
            if (result.getData() != null && RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList") != null && (cpisUserMap = (Map)(cpisUserListMap = (Map)RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList")).get(id)) != null) {
                userPo.setUserId((String)cpisUserMap.get("userId"));
                userPo.setUserName((String)cpisUserMap.get("userName"));
            }
        } else {
            Map cpisUserListMap = (Map)RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList");
            Map cpisUserMap = (Map)cpisUserListMap.get(id);
            if (cpisUserMap != null) {
                userPo.setUserId((String)cpisUserMap.get("userId"));
                userPo.setUserName((String)cpisUserMap.get("userName"));
            }
        }
        return userPo;
    }

    public static List<CpisUserPo> getCpisUserList(List<String> userIds) {
        ArrayList<CpisUserPo> userPoList;
        block3: {
            block2: {
                userPoList = new ArrayList<CpisUserPo>();
                if (RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList") != null) break block2;
                APIResult<Boolean> result = feginExtendService.getCpisUserList();
                if (result.getData() == null || RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList") == null) break block3;
                Map cpisUserListMap = (Map)RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList");
                for (String id : userIds) {
                    Map cpisUserMap = (Map)cpisUserListMap.get(id);
                    if (cpisUserMap == null) continue;
                    CpisUserPo userPo = new CpisUserPo();
                    userPo.setUserId((String)cpisUserMap.get("userId"));
                    userPo.setUserName((String)cpisUserMap.get("userName"));
                    userPoList.add(userPo);
                }
                break block3;
            }
            Map cpisUserListMap = (Map)RedisUtil.redisTemplate.opsForValue().get((Object)"cpis-base:cpis:user:cpisUserList");
            for (String id : userIds) {
                Map cpisUserMap = (Map)cpisUserListMap.get(id);
                if (cpisUserMap == null) continue;
                CpisUserPo userPo = new CpisUserPo();
                userPo.setUserId((String)cpisUserMap.get("userId"));
                userPo.setUserName((String)cpisUserMap.get("userName"));
                userPoList.add(userPo);
            }
        }
        return userPoList;
    }

    public static JSONObject getUserInfoByToken(String token) {
        if (StringUtil.isEmpty((CharSequence)token)) {
            return null;
        }
        JSONObject response = feginOauthService.verify(token);
        String userName = response.get((Object)"data").toString();
        if (StringUtil.isNotEmpty((CharSequence)userName)) {
            response = CpisRedisUtil.getUserInfoByUserName(userName);
        }
        return response;
    }

    public static JSONObject getUserInfoByUserName(String userName) {
        JSONObject response = new JSONObject();
        if (RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:user:userInfo-token" + userName)) == null) {
            Map<String, Object> response1 = feginOauthService.findUserContext(userName);
            response = new JSONObject(response1);
            RedisUtil.redisTemplate.opsForValue().set((Object)("cpis-base:cpis:user:userInfo-token" + userName), (Object)response, 30L, TimeUnit.MINUTES);
        } else {
            response = (JSONObject)RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:user:userInfo-token" + userName));
        }
        return response;
    }

    public static String getBizDataRole(String userId, String bizKey) {
        String SQL = "";
        if (RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + userId)) == null) {
            APIResult<Map<String, Object>> result = feginExtendService.getDataRole(userId);
            Map data = (Map)result.getData();
            if (data != null) {
                SQL = CpisRedisUtil.getSql((Map)data.get("cpis-base:cpis:auth:dataRole-" + userId), bizKey);
            }
        } else {
            SQL = CpisRedisUtil.getSql((Map)RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + userId)), bizKey);
        }
        return SQL;
    }

    public static String getDataAuthSql(String userId, String bizKey, List<String> dataAuthOffList) {
        if (CollectionUtils.isNotEmpty(dataAuthOffList)) {
            for (String key : dataAuthOffList) {
                if (!bizKey.equalsIgnoreCase(key)) continue;
                return "";
            }
        }
        String SQL = "";
        if (RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + userId)) == null) {
            APIResult<Map<String, Object>> result = feginExtendService.getDataRole(userId);
            Map data = (Map)result.getData();
            if (data != null) {
                SQL = CpisRedisUtil.getSql((Map)data.get("cpis-base:cpis:auth:dataRole-" + userId), bizKey);
            }
        } else {
            SQL = CpisRedisUtil.getSql((Map)RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + userId)), bizKey);
        }
        return SQL;
    }

    public static String getThirdDataAuthSql(String thirdTag, String bizKey, List<String> dataAuthOffList) {
        if (CollectionUtils.isNotEmpty(dataAuthOffList)) {
            for (String key : dataAuthOffList) {
                if (!bizKey.equalsIgnoreCase(key)) continue;
                return "";
            }
        }
        String SQL = "";
        if (RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + thirdTag)) == null) {
            APIResult<Map<String, Object>> result = feginExtendService.getDataByThirdTag(thirdTag);
            Map data = (Map)result.getData();
            if (data != null) {
                SQL = CpisRedisUtil.getSql((Map)data.get("cpis-base:cpis:auth:dataRole-" + thirdTag), bizKey);
            }
        } else {
            SQL = CpisRedisUtil.getSql((Map)RedisUtil.redisTemplate.opsForValue().get((Object)("cpis-base:cpis:auth:dataRole-" + thirdTag)), bizKey);
        }
        return SQL;
    }

    public static String getSql(Map<String, String> data, String bizKey) {
        String SQL = "";
        if (data != null) {
            for (String key : data.keySet()) {
                if (!bizKey.equals(key)) continue;
                SQL = data.get(key);
            }
        }
        return SQL;
    }
}

