/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.utils;

import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.producer.ICpisQueueProducer;
import com.cpis.rabbitmq.producer.RabbitCpisMessageQueueProducer;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.saas.context.TenantContext;
import com.lc.ibps.cloud.mq.core.model.DefaultMessage;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CpisMessageProductorUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(CpisMessageProductorUtil.class);
    private static ThreadLocal<Boolean> ignoreException = new InheritableThreadLocal<Boolean>();
    private static ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducer = new RabbitCpisMessageQueueProducer();
    @Resource
    @Qualifier(value="RabbitCpisMessageQueueProducer")
    private ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducerTemp = new RabbitCpisMessageQueueProducer();

    public static void setIgnoreException() {
        ignoreException.set(true);
    }

    public static void removeIgnoreException() {
        ignoreException.remove();
    }

    private static boolean isIgnoreException() {
        return Optional.ofNullable(ignoreException.get()).orElse(false);
    }

    @PostConstruct
    public void init() {
        cpisMessageQueueProducer = this.cpisMessageQueueProducerTemp;
    }

    public static <D extends Serializable> void send(CpisTranMessagePo data) {
        if (!CpisMessageProductorUtil.isEnabled()) {
            return;
        }
        DefaultMessage message = new DefaultMessage();
        message.setTenantId(TenantContext.getCurrentTenantId());
        if (StringUtil.isNotEmpty((CharSequence)data.getMessageType())) {
            message.setMessageType(data.getMessageType());
        } else {
            message.setMessageType("biz");
        }
        message.setRouting(StringUtil.isBlank((CharSequence)data.getRoutingKey()) ? "ibps.routing.key.cpis.message" : data.getRoutingKey());
        message.setExchange(StringUtil.isBlank((CharSequence)data.getExchange()) ? "ibps.exchange.cpis.message" : data.getExchange());
        message.setQueue(StringUtil.isBlank((CharSequence)data.getQueue()) ? "ibps.queue.cpis.message" : data.getQueue());
        if (BeanUtils.isEmpty(data.getVars())) {
            message.setVariables(data.getVars());
        }
        message.setSenderId(data.getId());
        message.setData((Serializable)data);
        CpisMessageProductorUtil.send(message);
    }

    public static void send(DefaultMessage<?> message) {
        if (!CpisMessageProductorUtil.isEnabled()) {
            return;
        }
        if (null == message) {
            LOGGER.warn("Message object is null.");
            return;
        }
        try {
            cpisMessageQueueProducer.push(message);
        }
        catch (Exception e) {
            if (CpisMessageProductorUtil.isIgnoreException()) {
                LOGGER.warn("{}", (Object)e.getMessage(), (Object)e);
            }
            throw e;
        }
    }

    private static boolean isEnabled() {
        return true;
    }
}

