/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.rabbitmq.io.CpisBaseTranMessageIo;
import com.cpis.rabbitmq.mapper.CpisTranMessageMapper;
import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.service.CpisTranMessageService;
import com.cpis.rabbitmq.utils.CpisMessageProductorUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CpisTranMessageServiceImpl
extends ServiceImpl<CpisTranMessageMapper, CpisTranMessagePo>
implements CpisTranMessageService {
    @Override
    public CpisTranMessagePo getDetail(String id) {
        CpisTranMessagePo cpisTranMessagePo = (CpisTranMessagePo)((CpisTranMessageMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (cpisTranMessagePo == null) {
            return null;
        }
        return cpisTranMessagePo;
    }

    @Override
    public boolean add(CpisTranMessagePo cpisTranMessagePo) {
        cpisTranMessagePo.setCreateTime(new Date());
        cpisTranMessagePo.setUpdateTime(new Date());
        cpisTranMessagePo.setAckState(0);
        cpisTranMessagePo.setSendState(0);
        cpisTranMessagePo.setSendNum(0);
        if (StringUtil.isEmpty((CharSequence)cpisTranMessagePo.getMessageHeader())) {
            JSONObject jsonObjectHeader = new JSONObject();
            jsonObjectHeader.put("exchange", (Object)cpisTranMessagePo.getExchange());
            jsonObjectHeader.put("routingKey", (Object)cpisTranMessagePo.getRoutingKey());
            jsonObjectHeader.put("queue", (Object)cpisTranMessagePo.getQueue());
            cpisTranMessagePo.setMessageHeader(jsonObjectHeader.toJSONString());
        }
        Boolean flag = ((CpisTranMessageMapper)this.baseMapper).insert(cpisTranMessagePo) > 0;
        CpisMessageProductorUtil.send(cpisTranMessagePo);
        return flag;
    }

    @Override
    public boolean iotAdd(CpisTranMessagePo cpisTranMessagePo) {
        cpisTranMessagePo.setCreateTime(new Date());
        cpisTranMessagePo.setUpdateTime(new Date());
        cpisTranMessagePo.setAckState(0);
        cpisTranMessagePo.setSendState(0);
        cpisTranMessagePo.setSendNum(0);
        if (StringUtil.isEmpty((CharSequence)cpisTranMessagePo.getMessageHeader())) {
            JSONObject jsonObjectHeader = new JSONObject();
            jsonObjectHeader.put("exchange", (Object)cpisTranMessagePo.getExchange());
            jsonObjectHeader.put("routingKey", (Object)cpisTranMessagePo.getRoutingKey());
            jsonObjectHeader.put("queue", (Object)cpisTranMessagePo.getQueue());
            cpisTranMessagePo.setMessageHeader(jsonObjectHeader.toJSONString());
        }
        return ((CpisTranMessageMapper)this.baseMapper).insert(cpisTranMessagePo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean edit(CpisTranMessagePo cpisTranMessagePo) {
        cpisTranMessagePo.setUpdateTime(new Date());
        return ((CpisTranMessageMapper)this.baseMapper).updateById(cpisTranMessagePo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBySchedule(CpisTranMessagePo cpisTranMessagePo) {
        cpisTranMessagePo.setUpdateTime(new Date());
        if (StringUtil.isEmpty((CharSequence)cpisTranMessagePo.getExchange()) && StringUtil.isNotEmpty((CharSequence)cpisTranMessagePo.getMessageHeader())) {
            JSONObject jsonObjectHeader = JSONObject.parseObject((String)cpisTranMessagePo.getMessageHeader());
            if (StringUtil.isNotEmpty((CharSequence)((String)jsonObjectHeader.get((Object)"exchange")))) {
                cpisTranMessagePo.setExchange((String)jsonObjectHeader.get((Object)"exchange"));
            }
            if (StringUtil.isNotEmpty((CharSequence)((String)jsonObjectHeader.get((Object)"routingKey")))) {
                cpisTranMessagePo.setRoutingKey((String)jsonObjectHeader.get((Object)"routingKey"));
            }
            if (StringUtil.isNotEmpty((CharSequence)((String)jsonObjectHeader.get((Object)"queue")))) {
                cpisTranMessagePo.setQueue((String)jsonObjectHeader.get((Object)"queue"));
            }
        }
        ((CpisTranMessageMapper)this.baseMapper).updateById(cpisTranMessagePo);
        CpisMessageProductorUtil.send(cpisTranMessagePo);
    }

    @Override
    public List<CpisTranMessagePo> getFailTranMessageList(QueryWrapper<CpisTranMessagePo> queryWrapper) {
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CpisTranMessagePo> getFailTranMessageList(List<String> bizKeyList, Integer addSendTimeMin, Integer addAckTimeMin) {
        return ((CpisTranMessageMapper)this.baseMapper).getFailTranMessageList(bizKeyList, addSendTimeMin, addAckTimeMin);
    }

    @Override
    public List<CpisTranMessagePo> getTranMessageList(QueryWrapper<CpisTranMessagePo> queryWrapper) {
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Page<CpisTranMessagePo> listByPage(CpisBaseTranMessageIo cpisBaseTranMessageIo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (cpisBaseTranMessageIo.getAckState() != null) {
            queryWrapper.eq((Object)"ack_state", (Object)cpisBaseTranMessageIo.getAckState());
        }
        if (cpisBaseTranMessageIo.getSendState() != null) {
            queryWrapper.eq((Object)"send_state", (Object)cpisBaseTranMessageIo.getSendState());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageIo.getSource())) {
            queryWrapper.eq((Object)"source", (Object)cpisBaseTranMessageIo.getSource());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageIo.getSrcBiz())) {
            queryWrapper.eq((Object)"src_biz", (Object)cpisBaseTranMessageIo.getSrcBiz());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageIo.getSrcBizId())) {
            queryWrapper.eq((Object)"src_biz_id", (Object)cpisBaseTranMessageIo.getSrcBizId());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageIo.getTgtObj())) {
            queryWrapper.eq((Object)"tgt_obj", (Object)cpisBaseTranMessageIo.getTgtObj());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageIo.getTgtObjBiz())) {
            queryWrapper.eq((Object)"tgt_obj_biz", (Object)cpisBaseTranMessageIo.getTgtObjBiz());
        }
        if (cpisBaseTranMessageIo.getCreateTimeArea() != null && cpisBaseTranMessageIo.getCreateTimeArea().length == 2) {
            queryWrapper.ge((Object)"create_time", (Object)cpisBaseTranMessageIo.getCreateTimeArea()[0]);
            queryWrapper.le((Object)"create_time", (Object)cpisBaseTranMessageIo.getCreateTimeArea()[1]);
        }
        if (cpisBaseTranMessageIo.getSendTimeArea() != null && cpisBaseTranMessageIo.getSendTimeArea().length == 2) {
            queryWrapper.ge((Object)"send_time", (Object)cpisBaseTranMessageIo.getSendTimeArea()[0]);
            queryWrapper.le((Object)"send_time", (Object)cpisBaseTranMessageIo.getSendTimeArea()[1]);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page page = cpisBaseTranMessageIo.getPage();
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }
}

