/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.exception.config.CpisR;
import com.cpis.fegin.FeginEquipmentService;
import com.cpis.fegin.FeginExtendService;
import com.cpis.fegin.FeginInspectionService;
import com.cpis.fegin.FeginMaterialService;
import com.cpis.fegin.FeginTicketsService;
import com.cpis.fegin.FeginWorkOrderService;
import com.cpis.rabbitmq.io.CpisBaseTranMessageRecIo;
import com.cpis.rabbitmq.mapper.CpisTranMessageRecMapper;
import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.po.CpisTranMessageRecPo;
import com.cpis.rabbitmq.service.CpisTranMessageRecService;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.cloud.entity.APIResult;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CpisTranMessageRecServiceImpl
extends ServiceImpl<CpisTranMessageRecMapper, CpisTranMessageRecPo>
implements CpisTranMessageRecService {
    @Resource
    private FeginExtendService feginExtendService;
    @Resource
    private FeginTicketsService feginTicketsService;
    @Resource
    private FeginWorkOrderService feginWorkOrderService;
    @Resource
    private FeginInspectionService feginInspectionService;
    @Resource
    private FeginEquipmentService feginEquipmentService;
    @Resource
    private FeginMaterialService feginMaterialService;

    @Override
    public CpisTranMessageRecPo getDetail(String id) {
        CpisTranMessageRecPo cpisTranMessageRecDO = (CpisTranMessageRecPo)((CpisTranMessageRecMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (cpisTranMessageRecDO == null) {
            return null;
        }
        return cpisTranMessageRecDO;
    }

    @Override
    public boolean addMessageRecByCpisTranMessage(CpisTranMessagePo po) {
        CpisTranMessageRecPo cpisTranMessageRecPo = new CpisTranMessageRecPo();
        cpisTranMessageRecPo.setId(po.getId());
        cpisTranMessageRecPo.setTxId(po.getTxId());
        cpisTranMessageRecPo.setMessageContent(po.getMessageContent());
        cpisTranMessageRecPo.setMessageTopic(po.getMessageTopic());
        cpisTranMessageRecPo.setProcessState(0);
        cpisTranMessageRecPo.setProcessNum(0);
        cpisTranMessageRecPo.setMqId(po.getSrcBizId());
        cpisTranMessageRecPo.setProcessTime(new Date());
        cpisTranMessageRecPo.setCreateTime(new Date());
        cpisTranMessageRecPo.setUpdateTime(new Date());
        cpisTranMessageRecPo.setSource(po.getSource());
        cpisTranMessageRecPo.setNotifySenderState(0);
        cpisTranMessageRecPo.setTgtObjBiz(po.getTgtObjBiz());
        return ((CpisTranMessageRecMapper)this.baseMapper).insert(cpisTranMessageRecPo) > 0;
    }

    @Override
    public boolean add(CpisTranMessageRecPo cpisTranMessageRecPo) {
        cpisTranMessageRecPo.setCreateTime(new Date());
        cpisTranMessageRecPo.setUpdateTime(new Date());
        return ((CpisTranMessageRecMapper)this.baseMapper).insert(cpisTranMessageRecPo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean edit(CpisTranMessageRecPo cpisTranMessageRecPo) {
        cpisTranMessageRecPo.setUpdateTime(new Date());
        return ((CpisTranMessageRecMapper)this.baseMapper).updateById(cpisTranMessageRecPo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean handleMessageRec(Map<String, Object> vars) {
        CpisTranMessageRecPo cpisTranMessageRecPo = new CpisTranMessageRecPo();
        cpisTranMessageRecPo.setId(String.valueOf(vars.get("id")));
        cpisTranMessageRecPo.setTxId(String.valueOf(vars.get("txId")));
        cpisTranMessageRecPo.setMessageContent(String.valueOf(vars.get("messageContent")));
        cpisTranMessageRecPo.setMessageTopic(String.valueOf(vars.get("messageTopic")));
        cpisTranMessageRecPo.setCreateTime(new Date());
        cpisTranMessageRecPo.setProcessTime(new Date());
        cpisTranMessageRecPo.setCreateUser(String.valueOf(vars.get("createUser")));
        cpisTranMessageRecPo.setCreateUserId(String.valueOf(vars.get("createUserId")));
        cpisTranMessageRecPo.setProcessNum(0);
        cpisTranMessageRecPo.setProcessState(0);
        cpisTranMessageRecPo.setMqId(String.valueOf(vars.get("srcBizId")));
        cpisTranMessageRecPo.setSource(String.valueOf(vars.get("source")));
        cpisTranMessageRecPo.setNotifySenderState(0);
        cpisTranMessageRecPo.setTgtObjBiz(String.valueOf(vars.get("tgtObjBiz")));
        return ((CpisTranMessageRecMapper)this.baseMapper).insert(cpisTranMessageRecPo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStateByOk(String id) {
        CpisTranMessageRecPo cpisTranMessageRecPo = (CpisTranMessageRecPo)((CpisTranMessageRecMapper)this.baseMapper).selectById((Serializable)((Object)id));
        cpisTranMessageRecPo.setUpdateTime(new Date());
        cpisTranMessageRecPo.setProcessState(20);
        cpisTranMessageRecPo.setProcessNum(cpisTranMessageRecPo.getProcessNum() + 1);
        return ((CpisTranMessageRecMapper)this.baseMapper).updateById(cpisTranMessageRecPo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStateByFailed(String id) {
        CpisTranMessageRecPo cpisTranMessageRecPo = (CpisTranMessageRecPo)((CpisTranMessageRecMapper)this.baseMapper).selectById((Serializable)((Object)id));
        cpisTranMessageRecPo.setUpdateTime(new Date());
        cpisTranMessageRecPo.setProcessState(30);
        cpisTranMessageRecPo.setProcessNum(cpisTranMessageRecPo.getProcessNum() + 1);
        return ((CpisTranMessageRecMapper)this.baseMapper).updateById(cpisTranMessageRecPo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStateByFailed(String id, String remark) {
        CpisTranMessageRecPo cpisTranMessageRecPo = (CpisTranMessageRecPo)((CpisTranMessageRecMapper)this.baseMapper).selectById((Serializable)((Object)id));
        cpisTranMessageRecPo.setUpdateTime(new Date());
        cpisTranMessageRecPo.setProcessState(30);
        cpisTranMessageRecPo.setProcessNum(cpisTranMessageRecPo.getProcessNum() + 1);
        if (remark.length() < 512) {
            cpisTranMessageRecPo.setRemark(remark);
        } else {
            cpisTranMessageRecPo.setRemark(remark.substring(0, 510));
        }
        return ((CpisTranMessageRecMapper)this.baseMapper).updateById(cpisTranMessageRecPo) > 0;
    }

    @Override
    public void toNotifyTranMessageAck() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"notify_sender_state", (Object)0);
        Calendar calendar1 = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
        calendar1.add(5, -3);
        String three_days_ago = sdf1.format(calendar1.getTime());
        queryWrapper.ge((Object)"create_time", (Object)three_days_ago);
        List lists = this.list((Wrapper)queryWrapper);
        Map mapIds = lists.stream().collect(Collectors.groupingBy(CpisTranMessageRecPo::getSource, Collectors.mapping(CpisTranMessageRecPo::getId, Collectors.toList())));
        Iterator<String> iterator = mapIds.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "flow": {
                    this.handleRecSendStates((APIResult<Boolean>)this.feginExtendService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                    break;
                }
                case "cpis-provider-tickets": {
                    this.handleRecSendStates(this.feginTicketsService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                    break;
                }
                case "cpis-provider-workorder": {
                    this.handleRecSendStates(this.feginWorkOrderService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                    break;
                }
                case "cpis-provider-equipment": {
                    this.handleRecSendStates(this.feginEquipmentService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                    break;
                }
                case "cpis-provider-material": {
                    this.handleRecSendStates(this.feginMaterialService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                    break;
                }
                case "cpis-provider-inspection": {
                    this.handleRecSendStates(this.feginInspectionService.ackTranMessage(mapIds.get(key)), mapIds.get(key));
                }
            }
        }
    }

    @Override
    public List<CpisTranMessageRecPo> getHandleFailMessageList() {
        return ((CpisTranMessageRecMapper)this.baseMapper).getHandleFailMessageList();
    }

    @Override
    public Map<String, String> getStateListByIds(List<String> ids) {
        Map<String, String> data = new HashMap<String, String>();
        APIResult<Map<String, String>> result = this.feginExtendService.getFlowStateBySrcId(ids);
        if (result != null) {
            data = (Map)result.getData();
        }
        return data;
    }

    @Override
    public Page<CpisTranMessageRecPo> listByPage(CpisBaseTranMessageRecIo cpisBaseTranMessageRecIo) {
        Page page = cpisBaseTranMessageRecIo.getPage();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageRecIo.getSource())) {
            queryWrapper.eq((Object)"source", (Object)cpisBaseTranMessageRecIo.getSource());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageRecIo.getMqId())) {
            queryWrapper.eq((Object)"mq_id", (Object)cpisBaseTranMessageRecIo.getMqId());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisBaseTranMessageRecIo.getTgtObjBiz())) {
            queryWrapper.eq((Object)"tgt_obj_biz", (Object)cpisBaseTranMessageRecIo.getTgtObjBiz());
        }
        if (cpisBaseTranMessageRecIo.getProcessState() != null) {
            queryWrapper.eq((Object)"process_state", (Object)cpisBaseTranMessageRecIo.getProcessState());
        }
        if (cpisBaseTranMessageRecIo.getNotifySenderState() != null) {
            queryWrapper.eq((Object)"notify_sender_state", (Object)cpisBaseTranMessageRecIo.getNotifySenderState());
        }
        if (cpisBaseTranMessageRecIo.getCreateTimeArea() != null && cpisBaseTranMessageRecIo.getCreateTimeArea().length == 2) {
            queryWrapper.ge((Object)"create_time", (Object)cpisBaseTranMessageRecIo.getCreateTimeArea()[0]);
            queryWrapper.le((Object)"create_time", (Object)cpisBaseTranMessageRecIo.getCreateTimeArea()[1]);
        }
        if (cpisBaseTranMessageRecIo.getProcessTimeArea() != null && cpisBaseTranMessageRecIo.getProcessTimeArea().length == 2) {
            queryWrapper.ge((Object)"process_time", (Object)cpisBaseTranMessageRecIo.getProcessTimeArea()[0]);
            queryWrapper.le((Object)"process_time", (Object)cpisBaseTranMessageRecIo.getProcessTimeArea()[1]);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public void handleRecSendStates(APIResult<Boolean> result, List<String> ids) {
        if (ids.size() > 0 && result != null && result.getData() != null && ((Boolean)result.getData()).booleanValue()) {
            ((CpisTranMessageRecMapper)this.baseMapper).updateSendStatesByIds(ids);
        }
    }

    public void handleRecSendStates(CpisR<Boolean> result, List<String> ids) {
        if (ids.size() > 0 && result != null && result.getData() != null && result.getData().booleanValue()) {
            ((CpisTranMessageRecMapper)this.baseMapper).updateSendStatesByIds(ids);
        }
    }
}

