/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.properties;

import com.lc.ibps.base.core.util.EnvUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class RabbitConfigure {
    @Autowired
    private Environment env;
    public static final String hostKey = "spring.rabbitmq.host";
    private String host = "127.0.0.1";
    public static final String portKey = "spring.rabbitmq.port";
    private int port = 5672;
    public static final String addressesKey = "spring.rabbitmq.addresses";
    private String addresses = "";
    public static final String usernameKey = "spring.rabbitmq.username";
    private String username = "ibps";
    public static final String passwordKey = "spring.rabbitmq.password";
    private String password = "ibps@123";
    public static final String virtualHostKey = "spring.rabbitmq.virtual-host";
    private String virtualHost = "/ibps";
    public static final String publisherConfirmsKey = "spring.rabbitmq.publisher-confirms";
    private boolean publisherConfirms = true;
    public static final String connectionCacheSizeKey = "spring.rabbitmq.connection-cache-size";
    private int connectionCacheSize = 5;
    public static final String connectionLimitKey = "spring.rabbitmq.connection-limit";
    private int connectionLimit = 100;
    public static final String connectionTimeoutKey = "spring.rabbitmq.connection-timeout";
    private int connectionTimeout = 180000;
    public static final String concurrentConsumersKey = "spring.rabbitmq.concurrent-consumers";
    private int concurrentConsumers = 3;
    public static final String maxConcurrentConsumersKey = "spring.rabbitmq.max-concurrent-consumers";
    private int maxConcurrentConsumers = 10;
    public static final String prefetchCountKey = "spring.rabbitmq.prefetch-count";
    private int prefetchCount = 100;
    public static final String durableKey = "spring.rabbitmq.durable";
    private boolean durable = true;
    public static final String autoDeleteKey = "spring.rabbitmq.auto-delete";
    private boolean autoDelete = false;
    public static final String exclusiveKey = "spring.rabbitmq.exclusive";
    private boolean exclusive = false;
    public static final String retryKey = "spring.rabbitmq.retry";
    private Retry retry = new Retry();

    public String getHost() {
        if (this.env.containsProperty(hostKey)) {
            return this.env.getProperty(hostKey, this.host);
        }
        return this.host;
    }

    public int getPort() {
        if (this.env.containsProperty(portKey)) {
            return (Integer)this.env.getProperty(portKey, Integer.class, (Object)this.port);
        }
        return this.port;
    }

    public String getUsername() {
        if (this.env.containsProperty(usernameKey)) {
            return this.env.getProperty(usernameKey, this.username);
        }
        return this.username;
    }

    public String getPassword() {
        if (this.env.containsProperty(passwordKey)) {
            return this.env.getProperty(passwordKey, this.password);
        }
        return this.password;
    }

    public String getVirtualHost() {
        if (this.env.containsProperty(virtualHostKey)) {
            return this.env.getProperty(virtualHostKey, this.virtualHost);
        }
        return this.virtualHost;
    }

    public boolean isPublisherConfirms() {
        if (this.env.containsProperty(publisherConfirmsKey)) {
            return (Boolean)this.env.getProperty(publisherConfirmsKey, Boolean.class, (Object)this.publisherConfirms);
        }
        return this.publisherConfirms;
    }

    public int getConnectionCacheSize() {
        if (this.env.containsProperty(connectionCacheSizeKey)) {
            return (Integer)this.env.getProperty(connectionCacheSizeKey, Integer.class, (Object)this.connectionCacheSize);
        }
        return this.connectionCacheSize;
    }

    public int getConnectionLimit() {
        if (this.env.containsProperty(connectionLimitKey)) {
            return (Integer)this.env.getProperty(connectionLimitKey, Integer.class, (Object)this.connectionLimit);
        }
        return this.connectionLimit;
    }

    public int getConnectionTimeout() {
        if (this.env.containsProperty(connectionTimeoutKey)) {
            return (Integer)this.env.getProperty(connectionTimeoutKey, Integer.class, (Object)this.connectionTimeout);
        }
        return this.connectionTimeout;
    }

    public int getConcurrentConsumers() {
        if (this.env.containsProperty(concurrentConsumersKey)) {
            return (Integer)this.env.getProperty(concurrentConsumersKey, Integer.class, (Object)this.concurrentConsumers);
        }
        return this.concurrentConsumers;
    }

    public int getMaxConcurrentConsumers() {
        if (this.env.containsProperty(maxConcurrentConsumersKey)) {
            return (Integer)this.env.getProperty(maxConcurrentConsumersKey, Integer.class, (Object)this.maxConcurrentConsumers);
        }
        return this.maxConcurrentConsumers;
    }

    public int getPrefetchCount() {
        if (this.env.containsProperty(prefetchCountKey)) {
            return (Integer)this.env.getProperty(prefetchCountKey, Integer.class, (Object)this.prefetchCount);
        }
        return this.prefetchCount;
    }

    public String getAddresses() {
        if (this.env.containsProperty(addressesKey)) {
            return this.env.getProperty(addressesKey, this.addresses);
        }
        return null;
    }

    public boolean isDurable() {
        if (this.env.containsProperty(durableKey)) {
            return (Boolean)this.env.getProperty(durableKey, Boolean.class, (Object)this.durable);
        }
        return this.durable;
    }

    public boolean isAutoDelete() {
        if (this.env.containsProperty(autoDeleteKey)) {
            return (Boolean)this.env.getProperty(autoDeleteKey, Boolean.class, (Object)this.autoDelete);
        }
        return this.autoDelete;
    }

    public boolean isExclusive() {
        if (this.env.containsProperty(exclusiveKey)) {
            return (Boolean)this.env.getProperty(exclusiveKey, Boolean.class, (Object)this.exclusive);
        }
        return this.exclusive;
    }

    public Retry getRetry() {
        Retry r = (Retry)EnvUtil.getObjectProperty((Environment)this.env, (String)retryKey, Retry.class);
        if (r != null) {
            return r;
        }
        return this.retry;
    }

    public static class Retry {
        private boolean enabled = true;
        private int maxAttempts = 3;
        private long initialInterval = 1000L;
        private double multiplier = 3.0;
        private long maxInterval = 10000L;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public long getInitialInterval() {
            return this.initialInterval;
        }

        public void setInitialInterval(long initialInterval) {
            this.initialInterval = initialInterval;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public void setMultiplier(double multiplier) {
            this.multiplier = multiplier;
        }

        public long getMaxInterval() {
            return this.maxInterval;
        }

        public void setMaxInterval(long maxInterval) {
            this.maxInterval = maxInterval;
        }
    }
}

