/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.producer;

import cn.hutool.core.util.StrUtil;
import com.cpis.rabbitmq.config.RabbitMqBaseConfirmConfig;
import com.cpis.rabbitmq.config.RabbitMqBaseReturnCallbackConfig;
import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.producer.ICpisQueueProducer;
import com.cpis.rabbitmq.service.CpisTranMessageService;
import com.lc.ibps.cloud.mq.core.model.Message;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.stereotype.Service;

@Service(value="RabbitCpisMessageQueueProducer")
public class RabbitCpisMessageQueueProducer<T extends Message<?>>
implements ICpisQueueProducer<T> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitCpisMessageQueueProducer.class);
    @Resource(name="rabbitBaseTemplate")
    private RabbitTemplate rabbitBaseTemplate;
    @Resource
    private RabbitMqBaseConfirmConfig rabbitMqBaseConfirmConfig;
    @Resource
    private RabbitMqBaseReturnCallbackConfig baseReturnCallbackConfig;
    @Resource
    private CpisTranMessageService cpisTranMessageService;

    @Override
    public void push(T message) {
        CpisTranMessagePo po;
        String exchange = "ibps.exchange.cpis.message";
        String routing = "ibps.routing.key.cpis.message";
        if (StrUtil.isNotBlank((CharSequence)message.getExchange())) {
            exchange = message.getExchange();
        }
        if (StrUtil.isNotBlank((CharSequence)message.getRouting())) {
            routing = message.getRouting();
        }
        if ((po = this.cpisTranMessageService.getDetail(message.getSenderId())) != null) {
            po.setSendState(10);
            po.setSendNum(po.getSendNum() + 1);
            po.setSendTime(new Date());
            this.cpisTranMessageService.edit(po);
        }
        logger.debug("send to exchange {}, routing {} of message {}.", new Object[]{exchange, routing, message});
        this.rabbitBaseTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this.rabbitMqBaseConfirmConfig);
        this.rabbitBaseTemplate.setReturnCallback((RabbitTemplate.ReturnCallback)this.baseReturnCallbackConfig);
        final String messageId = message.getSenderId();
        this.rabbitBaseTemplate.convertAndSend(exchange, routing, message, new MessagePostProcessor(){

            public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                message.getMessageProperties().setHeader("x-delay", (Object)"60000");
                message.getMessageProperties().setDelay(Integer.valueOf(60000));
                message.getMessageProperties().setExpiration("600000");
                message.getMessageProperties().setMessageId(messageId);
                return message;
            }
        }, new CorrelationData(message.getSenderId()));
    }
}

