/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.producer;

import cn.hutool.core.util.StrUtil;
import com.cpis.rabbitmq.config.RabbitMqBusinessConfirmConfig;
import com.cpis.rabbitmq.config.RabbitMqBussineReturnCallbackConfig;
import com.cpis.rabbitmq.producer.ICpisQueueProducer;
import com.lc.ibps.cloud.mq.core.model.Message;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.stereotype.Service;

@Service(value="BusinessLogQueueProducer")
public class BusinessLogQueueProducer<T extends Message<?>>
implements ICpisQueueProducer<T> {
    private static final Logger logger = LoggerFactory.getLogger(BusinessLogQueueProducer.class);
    @Resource(name="rabbitBussineLogTemplate")
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitMqBusinessConfirmConfig businessConfirmConfig;
    @Resource
    private RabbitMqBussineReturnCallbackConfig bussineReturnCallbackConfig;

    @Override
    public void push(T message) {
        String exchange = "ibps.exchange.cpis.message";
        String routing = "ibps.routing.key.cpis.message";
        if (StrUtil.isNotBlank((CharSequence)message.getExchange())) {
            exchange = message.getExchange();
        }
        if (StrUtil.isNotBlank((CharSequence)message.getRouting())) {
            routing = message.getRouting();
        }
        this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this.businessConfirmConfig);
        this.rabbitTemplate.setReturnCallback((RabbitTemplate.ReturnCallback)this.bussineReturnCallbackConfig);
        logger.debug("send to exchange {}, routing {} of message {}.", new Object[]{exchange, routing, message});
        final String messageId = message.getSenderId();
        this.rabbitTemplate.convertAndSend(exchange, routing, message, new MessagePostProcessor(){

            public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                message.getMessageProperties().setHeader("x-delay", (Object)"60000");
                message.getMessageProperties().setDelay(Integer.valueOf(60000));
                message.getMessageProperties().setExpiration("600000");
                message.getMessageProperties().setMessageId(messageId);
                return message;
            }
        }, new CorrelationData(message.getSenderId()));
    }
}

