/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.config;

import com.cpis.push.po.BusinessLogBean;
import com.cpis.push.service.BusinessLogService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqBusinessConfirmConfig
implements RabbitTemplate.ConfirmCallback {
    @Resource(name="rabbitBussineLogTemplate")
    private RabbitTemplate rabbitTemplate;
    @Resource
    private BusinessLogService businessLogService;

    @PostConstruct
    public void init() {
        this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        List<BusinessLogBean> businessLogBeanList = this.businessLogService.getList(correlationData.getId());
        if (businessLogBeanList.size() > 0) {
            businessLogBeanList = ack ? businessLogBeanList.stream().map(bean -> {
                bean.setSendStatus(20);
                bean.setLockState(0);
                bean.setAckState(20);
                bean.setAckTime(new Date());
                return bean;
            }).collect(Collectors.toList()) : businessLogBeanList.stream().map(bean -> {
                bean.setSendStatus(30);
                bean.setLockState(0);
                return bean;
            }).collect(Collectors.toList());
            this.businessLogService.updateBatchById(businessLogBeanList);
        }
    }
}

