/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.config;

import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.service.CpisTranMessageService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqBaseReturnCallbackConfig
implements RabbitTemplate.ReturnCallback {
    @Resource(name="rabbitBaseTemplate")
    private RabbitTemplate rabbitBaseTemplate;
    @Resource
    private CpisTranMessageService cpisTranMessageService;

    @PostConstruct
    public void init() {
        this.rabbitBaseTemplate.setReturnCallback((RabbitTemplate.ReturnCallback)this);
    }

    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        CpisTranMessagePo po = this.cpisTranMessageService.getDetail(message.getMessageProperties().getMessageId());
        if (po != null) {
            po.setSendState(50);
            po.setSendNum(po.getSendNum() + 1);
            if (replyText.length() < 512) {
                po.setRemark(replyText);
            } else {
                po.setRemark(replyText.substring(0, 510));
            }
            this.cpisTranMessageService.edit(po);
        }
    }
}

