/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.config;

import com.cpis.rabbitmq.po.CpisTranMessagePo;
import com.cpis.rabbitmq.service.CpisTranMessageService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqBaseConfirmConfig
implements RabbitTemplate.ConfirmCallback {
    @Resource(name="rabbitBaseTemplate")
    private RabbitTemplate rabbitTemplate;
    @Resource
    private CpisTranMessageService cpisTranMessageService;

    @PostConstruct
    public void init() {
        this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        CpisTranMessagePo po = this.cpisTranMessageService.getDetail(correlationData.getId());
        if (po != null) {
            if (!ack) {
                po.setSendState(30);
                po.setSendNum(po.getSendNum() + 1);
                if (cause.length() < 512) {
                    po.setRemark(cause);
                } else {
                    po.setRemark(cause.substring(0, 510));
                }
            } else if (po.getSendState() == 50) {
                po.setSendState(30);
            } else {
                po.setSendState(20);
                po.setSendNum(po.getSendNum() + 1);
            }
            this.cpisTranMessageService.edit(po);
        }
    }
}

