/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.rabbitmq.config;

import com.cpis.rabbitmq.properties.RabbitConfigure;
import com.lc.ibps.base.core.util.string.StringUtil;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SerializerMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@EnableRabbit
@Configuration
public class RabbitMqBaseConfig {
    @Autowired
    private RabbitConfigure rabbitConfigure;

    @Bean
    @ConditionalOnMissingBean(name={"cpisBaseFactory"})
    public ConnectionFactory cpisBaseFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        if (StringUtil.isNotBlank((CharSequence)this.rabbitConfigure.getAddresses())) {
            connectionFactory.setAddresses(this.rabbitConfigure.getAddresses());
        } else {
            connectionFactory.setHost(this.rabbitConfigure.getHost());
            connectionFactory.setPort(this.rabbitConfigure.getPort());
        }
        connectionFactory.setUsername(this.rabbitConfigure.getUsername());
        connectionFactory.setPassword(this.rabbitConfigure.getPassword());
        connectionFactory.setVirtualHost(this.rabbitConfigure.getVirtualHost());
        connectionFactory.setPublisherConfirms(this.rabbitConfigure.isPublisherConfirms());
        connectionFactory.setPublisherReturns(this.rabbitConfigure.isPublisherConfirms());
        connectionFactory.setConnectionTimeout(this.rabbitConfigure.getConnectionTimeout());
        return connectionFactory;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"rabbitBaseTemplate"})
    public RabbitTemplate rabbitBaseTemplate() {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(this.cpisBaseFactory());
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setMessageConverter((MessageConverter)new SerializerMessageConverter());
        return rabbitTemplate;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"rabbitBussineLogTemplate"})
    public RabbitTemplate rabbitBussineLogTemplate() {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(this.cpisBaseFactory());
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setMessageConverter((MessageConverter)new SerializerMessageConverter());
        return rabbitTemplate;
    }
}

