/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.push.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.fegin.FeginPlatformService;
import com.cpis.push.mapper.BusinessLogMapper;
import com.cpis.push.po.BusinessLogBean;
import com.cpis.push.service.DataLockService;
import com.cpis.push.vo.CustMessageVo;
import com.cpis.push.vo.PubMessageVo;
import com.cpis.rabbitmq.producer.BusinessLogQueueProducer;
import com.cpis.rabbitmq.producer.ICpisQueueProducer;
import com.lc.ibps.base.saas.context.TenantContext;
import com.lc.ibps.cloud.entity.APIResult;
import com.lc.ibps.cloud.mq.core.model.DefaultMessage;
import com.lc.ibps.common.cat.persistence.entity.DictionaryPo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BusinessLogService
extends ServiceImpl<BusinessLogMapper, BusinessLogBean> {
    @Value(value="${cpis.business.push.num:10}")
    private Integer num;
    @Value(value="${cpis.business.push.totalNum:100}")
    private Integer totalNum;
    @Value(value="#{'${cpis.business.push.bizCode:push}'.split(',')}")
    private List<String> bizCodeList;
    @Value(value="${spring.application.name}")
    private String serverName;
    @Resource
    private FeginPlatformService feginPlatformService;
    @Resource
    private DataLockService dataLockService;
    private static ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducer = new BusinessLogQueueProducer();
    @Autowired
    @Qualifier(value="BusinessLogQueueProducer")
    private ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducerTemp = new BusinessLogQueueProducer();

    @PostConstruct
    public void init() {
        cpisMessageQueueProducer = this.cpisMessageQueueProducerTemp;
    }

    public void writeBusinessChangeLog(BusinessLogBean businessLogBean) {
        APIResult<List<DictionaryPo>> result = this.feginPlatformService.findByTypeKey("ChangeBusinessType");
        boolean flag = true;
        if (((List)result.getData()).size() > 0) {
            for (DictionaryPo dictionaryPo : (List)result.getData()) {
                if (!dictionaryPo.getKey().equals(businessLogBean.getBusinessType())) continue;
                flag = false;
                break;
            }
        }
        if (flag) {
            return;
        }
        if ("add".equals(businessLogBean.getChangeType()) && "edit".equals(businessLogBean.getChangeType()) && StringUtils.isBlank((CharSequence)businessLogBean.getBusinessId())) {
            new RuntimeException("\u65b0\u589e/\u4fee\u6539\u72b6\u6001\u4e1a\u52a1ID\u5fc5\u586b");
        }
        BusinessLogBean businessLog = new BusinessLogBean();
        BeanUtils.copyProperties((Object)businessLogBean, (Object)businessLog);
        this.save(businessLog);
    }

    public void pushChangeBusinessLog() throws InterruptedException {
        int i;
        APIResult<List<DictionaryPo>> result;
        boolean flag = true;
        if (this.bizCodeList.size() > 0 && ((List)(result = this.feginPlatformService.findByTypeKey("ChangeBusinessType")).getData()).size() > 0) {
            for (DictionaryPo dictionaryPo : (List)result.getData()) {
                if (!this.bizCodeList.contains(dictionaryPo.getKey())) continue;
                flag = false;
                break;
            }
        }
        if (flag) {
            return;
        }
        List dataLockBeanList = this.dataLockService.list((Wrapper)new QueryWrapper().eq((Object)"data_lock_code", (Object)"biz_log_push"));
        if (dataLockBeanList.size() == 0) {
            new RuntimeException("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u9501");
            return;
        }
        int counum = this.dataLockService.getDataLock("biz_log_push", 60);
        if (counum == 0 && (i = 0) < 6) {
            Thread.sleep(10000L);
            counum = this.dataLockService.getDataLock("biz_log_push", 60);
            if (counum <= 0) {
                return;
            }
        }
        ((BusinessLogMapper)this.baseMapper).updateState();
        List<BusinessLogBean> businessList = ((BusinessLogMapper)this.baseMapper).findList(this.totalNum);
        ArrayList businessLogList = new ArrayList();
        ArrayList businessLogBeanList = new ArrayList();
        businessList.forEach(businessLogBean -> {
            if (businessLogList.size() == 0 || !businessLogList.stream().filter(bean -> bean.getBusinessId().equals(businessLogBean.getBusinessId())).findAny().isPresent()) {
                businessLogList.add(businessLogBean);
            }
        });
        businessLogList.forEach(businessLogBean -> {
            if (businessLogBeanList.size() == 0 || !businessLogBeanList.stream().filter(bean -> bean.getLockState() == 1).findAny().isPresent()) {
                businessLogBeanList.add(businessLogBean);
            }
        });
        PubMessageVo pubMessageVo = new PubMessageVo();
        pubMessageVo.setMsgId(String.valueOf(UUID.randomUUID()));
        pubMessageVo.setService(this.serverName);
        ArrayList custMessageVoList = new ArrayList();
        int[] count = new int[]{0};
        int countNum = businessLogBeanList.size() / this.num + (businessLogBeanList.size() % this.num != 0 ? 1 : 0);
        int[] cotNum = new int[]{this.num};
        businessLogBeanList.forEach(businessLogBean -> {
            businessLogBean.setSendStatus(10);
            businessLogBean.setLockState(1);
            businessLogBean.setLockTime(new Date());
            businessLogBean.setSendTime(new Date());
            businessLogBean.setSendNum(businessLogBean.getSendNum() + 1);
            businessLogBean.setBatckId(pubMessageVo.getMsgId());
            this.updateById(businessLogBean);
            CustMessageVo custMessageVo = new CustMessageVo();
            custMessageVo.setBizType(businessLogBean.getBusinessType());
            custMessageVo.setChangeType(businessLogBean.getChangeType());
            custMessageVo.setLogId(businessLogBean.getLogId());
            custMessageVo.setBusinessId(businessLogBean.getBusinessId());
            custMessageVo.setBizData(businessLogBean.getBusinessInfo());
            custMessageVo.setCompanyId(businessLogBean.getCompanyId());
            custMessageVo.setChangeTime(businessLogBean.getChangeTime());
            custMessageVoList.add(custMessageVo);
            if (countNum - 1 == count[0]) {
                cotNum[0] = businessLogBeanList.size() % cotNum[0] != 0 ? businessLogBeanList.size() % cotNum[0] : cotNum[0];
                this.dataLockService.freeDataLock("biz_log_push");
            }
            if (businessLogBeanList.size() <= count[0] * cotNum[0] || custMessageVoList.size() == cotNum[0]) {
                count[0] = count[0] + 1;
                JSONArray jsonArray = JSONArray.fromObject((Object)custMessageVoList);
                pubMessageVo.setBizInfos(jsonArray.toString());
                BusinessLogService.sendMq(pubMessageVo);
                custMessageVoList.clear();
            }
        });
    }

    private static void sendMq(PubMessageVo pubMessageVo) {
        DefaultMessage message = new DefaultMessage();
        message.setTenantId(TenantContext.getCurrentTenantId());
        message.setMessageType("change-log");
        message.setRouting("cpis-provider-push");
        message.setExchange("ibps.exchange.cpis.message");
        message.setQueue("cpis-provider-push");
        message.setSenderId(pubMessageVo.getMsgId());
        message.setData((Serializable)pubMessageVo);
        cpisMessageQueueProducer.push(message);
    }

    public List<BusinessLogBean> getList(String batckId) {
        return ((BusinessLogMapper)this.baseMapper).getList(batckId);
    }
}

