/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.push.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.fegin.FeginExtendService;
import com.cpis.push.mapper.AlarmTypeMappingMapper;
import com.cpis.push.po.AlarmTypeMapping;
import com.lc.ibps.cloud.redis.utils.RedisUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="alarmTypeMappingService")
public class AlarmTypeMappingService
extends ServiceImpl<AlarmTypeMappingMapper, AlarmTypeMapping> {
    private static final String key = "cpis-base:cpis:push:";
    @Resource
    private FeginExtendService feginExtendService;

    public AlarmTypeMapping getThridAlarmMapping(String thirdCode, String thirdAlarmTypeCode, String thirdAlarmCode) {
        if (!StringUtils.hasText((String)thirdAlarmTypeCode)) {
            thirdAlarmCode = "empty";
        }
        AlarmTypeMapping alarmTypeMapping = null;
        String mappingKey = "cpis-base:cpis:push::" + thirdCode + "-" + thirdAlarmCode + "-" + thirdAlarmCode;
        if (RedisUtil.redisTemplate().hasKey((Object)mappingKey).booleanValue()) {
            alarmTypeMapping = (AlarmTypeMapping)RedisUtil.redisTemplate().opsForValue().get((Object)mappingKey);
        } else {
            List<AlarmTypeMapping> thirdAlarmMapping = this.getThirdAlarmMapping();
            String finalThirdAlarmCode = thirdAlarmCode;
            Optional<AlarmTypeMapping> mappingOptional = thirdAlarmMapping.stream().filter(mapping -> mapping.getThirdCode().equals(thirdCode) && mapping.getThirdAlarmTypeCode().equals(thirdAlarmTypeCode) && mapping.getThirdAlarmCode().equals(finalThirdAlarmCode)).findFirst();
            if (mappingOptional.isPresent()) {
                alarmTypeMapping = mappingOptional.get();
                RedisUtil.redisTemplate().opsForValue().set((Object)mappingKey, (Object)alarmTypeMapping, 1L, TimeUnit.DAYS);
            }
        }
        return alarmTypeMapping;
    }

    private List<AlarmTypeMapping> getThirdAlarmMapping() {
        List alarmTypeMappingList;
        String alarmTypeKey = "cpis-base:cpis:push:alarmTypeMapping";
        if (RedisUtil.redisTemplate().hasKey((Object)alarmTypeKey).booleanValue()) {
            alarmTypeMappingList = (List)RedisUtil.redisTemplate().opsForValue().get((Object)key);
        } else {
            alarmTypeMappingList = (List)this.feginExtendService.listAlarmTypeMapping().getData();
            RedisUtil.redisTemplate().opsForValue().set((Object)alarmTypeKey, (Object)((Serializable)((Object)alarmTypeMappingList)), 1L, TimeUnit.DAYS);
        }
        return alarmTypeMappingList;
    }
}

