/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.log.config;

import com.cpis.log.aspect.DebugLogAdvice;
import com.cpis.log.aspect.ExceptionLogAdvice;
import com.cpis.log.aspect.PerformanceLogAdvice;
import com.cpis.log.aspect.RequestLogAdvice;
import com.cpis.log.common.LogButton;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Configuration
@Service
@Order(value=1)
public class LogAopConfig {
    @Value(value="${pointcut.property.request}")
    private String requestPointcut;
    @Value(value="${pointcut.property.performance}")
    private String performancePointcut;
    @Value(value="${pointcut.property.exception}")
    private String exceptionPointcut;
    @Value(value="${pointcut.property.debug}")
    private String debugPointcut;
    @Value(value="${pointcut.button.debug}")
    private String debugButton;
    @Value(value="${pointcut.button.job}")
    private String jobButton;
    @Value(value="${pointcut.button.performance}")
    private String performanceButton;
    @Value(value="${pointcut.button.request}")
    private String requestButton;
    @Value(value="${pointcut.parameterButton.request}")
    private String requestParameterButton;
    @Value(value="${pointcut.parameterButton.response}")
    private String responseParameterButton;

    @Bean
    public AspectJExpressionPointcutAdvisor requestConfigurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        LogButton logButton = new LogButton();
        logButton.setReqbutton(this.requestParameterButton);
        logButton.setResbutton(this.responseParameterButton);
        RequestLogAdvice requestLogAdvice = new RequestLogAdvice();
        requestLogAdvice.setLogButton(logButton);
        if (this.requestPointcut.equals(this.performancePointcut) && this.exceptionPointcut.equals(this.requestPointcut)) {
            if ("false".equals(this.requestButton)) {
                advisor.setExpression("execution(* com.cpis.log.common.DebugLog.noDoMethod())");
                advisor.setAdvice((Advice)requestLogAdvice);
            } else {
                advisor.setExpression(this.requestPointcut);
                advisor.setAdvice((Advice)requestLogAdvice);
            }
        } else if ("false".equals(this.requestButton)) {
            advisor.setExpression("execution(* com.cpis.log.common.DebugLog.noDoMethod())");
            advisor.setAdvice((Advice)requestLogAdvice);
        } else {
            advisor.setExpression(this.requestPointcut);
            advisor.setAdvice((Advice)requestLogAdvice);
        }
        return advisor;
    }

    @Bean
    public AspectJExpressionPointcutAdvisor performanceConfigurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        PerformanceLogAdvice performanceLogAdvice = new PerformanceLogAdvice();
        LogButton logButton = new LogButton();
        logButton.setReqbutton(this.requestParameterButton);
        logButton.setResbutton(this.responseParameterButton);
        performanceLogAdvice.setLogButton(logButton);
        if (this.requestPointcut.equals(this.performancePointcut) && this.exceptionPointcut.equals(this.requestPointcut)) {
            if ("false".equals(this.performanceButton)) {
                advisor.setExpression("execution(* com.cpis.log.common.DebugLog.noDoMethod())");
                advisor.setAdvice((Advice)performanceLogAdvice);
            } else {
                advisor.setExpression(this.performancePointcut);
                advisor.setAdvice((Advice)performanceLogAdvice);
            }
        } else if ("false".equals(this.performanceButton)) {
            advisor.setExpression("execution(* com.cpis.log.common.DebugLog.noDoMethod())");
            advisor.setAdvice((Advice)performanceLogAdvice);
        } else {
            advisor.setExpression(this.performancePointcut);
            advisor.setAdvice((Advice)performanceLogAdvice);
        }
        return advisor;
    }

    @Bean
    public AspectJExpressionPointcutAdvisor exceptionConfigurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        ExceptionLogAdvice exceptionLogAdvice = new ExceptionLogAdvice();
        LogButton logButton = new LogButton();
        logButton.setReqbutton(this.requestParameterButton);
        logButton.setResbutton(this.responseParameterButton);
        exceptionLogAdvice.setLogButton(logButton);
        if (this.requestPointcut.equals(this.performancePointcut) && this.exceptionPointcut.equals(this.requestPointcut)) {
            advisor.setExpression(this.exceptionPointcut);
            advisor.setAdvice((Advice)exceptionLogAdvice);
        } else {
            advisor.setExpression(this.exceptionPointcut);
            advisor.setAdvice((Advice)exceptionLogAdvice);
        }
        return advisor;
    }

    @Bean
    public AspectJExpressionPointcutAdvisor debugConfigurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        if ("false".equals(this.debugButton)) {
            advisor.setExpression("execution(* com.cpis.log.common.DebugLog.noDoMethod())");
            advisor.setAdvice((Advice)new DebugLogAdvice());
        } else {
            advisor.setExpression(this.debugPointcut);
            advisor.setAdvice((Advice)new DebugLogAdvice());
        }
        return advisor;
    }
}

