/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.log.aspect;

import com.alibaba.fastjson.JSON;
import com.cpis.log.common.LogButton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class RequestLogAdvice
implements MethodInterceptor {
    private static final String START_TIME = "request-start";
    Logger requestLog = LoggerFactory.getLogger((String)"REQUEST_LOG");
    @Autowired
    private LogButton logButton;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.doBefore();
        Object result = null;
        result = invocation.proceed();
        this.saveOperLog(result);
        return result;
    }

    public void doBefore() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
            Long start = System.currentTimeMillis();
            request.setAttribute(START_TIME, (Object)start);
        }
    }

    public void saveOperLog(Object result) throws IOException {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
            String reqParams = "\u8bf7\u6c42\u53c2\u6570\u5173\u95ed";
            if (!"false".equals(this.logButton.getReqbutton())) {
                if ("GET".equalsIgnoreCase(request.getMethod())) {
                    Map<String, String> rtnMap = this.converMap(request.getParameterMap());
                    reqParams = String.valueOf(JSONObject.fromObject(rtnMap));
                }
                if ("post".equalsIgnoreCase(request.getMethod())) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    try {
                        while ((line = br.readLine()) != null) {
                            sb.append(line);
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    reqParams = sb.toString();
                }
            }
            String resParams = "\u8fd4\u56de\u53c2\u6570\u5173\u95ed";
            if (!"false".equals(this.logButton.getResbutton()) && result != null) {
                try {
                    resParams = JSON.toJSONString((Object)result);
                }
                catch (Exception e) {
                    resParams = "\u8fd4\u56de\u53c2\u6570\u8f6c\u6362\u5f02\u5e38";
                }
            }
            Long start = (Long)request.getAttribute(START_TIME);
            Long end = System.currentTimeMillis();
            this.requestLog.info("\u3010requestTime\u3011:{} --- \u3010URL\u3011:{} --- \u3010request parameter\u3011:{} --- \u3010response parameter\u3011:{} --- \u3010resTime\u3011:{}\u6beb\u79d2", new Object[]{new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(new Date()), request.getRequestURL(), reqParams, resParams, end - start});
        }
    }

    public Map<String, String> converMap(Map<String, String[]> paramMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (String key : paramMap.keySet()) {
            rtnMap.put(key, paramMap.get(key)[0]);
        }
        return rtnMap;
    }

    public LogButton getLogButton() {
        return this.logButton;
    }

    public void setLogButton(LogButton logButton) {
        this.logButton = logButton;
    }
}

