/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.log.aspect;

import com.cpis.log.common.LogButton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ExceptionLogAdvice
implements MethodInterceptor {
    Logger exceptionLog = LoggerFactory.getLogger((String)"EXCEPTION_LOG");
    @Autowired
    private LogButton logButton;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
            String startResquestTime = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(new Date());
            Method method = invocation.getMethod();
            Object result = null;
            try {
                result = invocation.proceed();
                return result;
            }
            catch (Exception e) {
                String reqParams = "\u8bf7\u6c42\u53c2\u6570\u5173\u95ed";
                if (!"false".equals(this.logButton.getReqbutton())) {
                    if ("GET".equalsIgnoreCase(request.getMethod())) {
                        Map<String, String> rtnMap = this.converMap(request.getParameterMap());
                        reqParams = String.valueOf(JSONObject.fromObject(rtnMap));
                    }
                    if ("post".equalsIgnoreCase(request.getMethod())) {
                        BufferedReader br = null;
                        try {
                            br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
                        }
                        catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                        String line = null;
                        StringBuilder sb = new StringBuilder();
                        try {
                            while ((line = br.readLine()) != null) {
                                sb.append(line);
                            }
                            br.close();
                        }
                        catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                        reqParams = sb.toString();
                    }
                }
                this.exceptionLog.error("\u3010time\u3011:{} --- \u3010Class:method\u3011:{} --- \u3010request parameter\u3011:{} --- \u3010exceptionType\u3011:{} --- \u3010exception\u3011:{}", new Object[]{startResquestTime, method, reqParams, e.getClass().getName(), this.stackTraceToString(e.getMessage(), e.getStackTrace())});
                throw e;
            }
        }
        Object result = invocation.proceed();
        return result;
    }

    public Map<String, String> converMap(Map<String, String[]> paramMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (String key : paramMap.keySet()) {
            rtnMap.put(key, paramMap.get(key)[0]);
        }
        return rtnMap;
    }

    public String stackTraceToString(String exceptionMessage, StackTraceElement[] elements) {
        StringBuffer strbuff = new StringBuffer();
        for (StackTraceElement stet : elements) {
            strbuff.append(stet + "\n");
        }
        String message = exceptionMessage + "\n\t" + strbuff.toString();
        return message;
    }

    public LogButton getLogButton() {
        return this.logButton;
    }

    public void setLogButton(LogButton logButton) {
        this.logButton = logButton;
    }
}

