/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.log.aspect;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class DebugLogAdvice
implements MethodInterceptor {
    private static final String START_TIME = "request-start";
    Logger logger = LoggerFactory.getLogger((String)"DEBUG_LOG");

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.doBefore(invocation.getMethod());
        Object result = invocation.proceed();
        return result;
    }

    public void doBefore(Method method) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
            Long start = System.currentTimeMillis();
            request.setAttribute(START_TIME, (Object)start);
            this.logger.info("\u3010time\u3011:{} --- \u3010Class-method\u3011:{} --- \u3010debugInfo\u3011:", (Object)new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(new Date()), (Object)method);
        }
    }
}

