/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.license.controller;

import com.baomidou.mybatisplus.extension.api.R;
import cpislicense.client.manager.ClientLicenseManager;
import de.schlichtherle.license.LicenseContent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6388\u6743\u4fe1\u606f", tags={"\u6388\u6743\u65e5\u671f"})
@RestController
@RequestMapping(value={"/license"})
public class CpisLicenseController {
    private static final Logger log = LoggerFactory.getLogger(CpisLicenseController.class);
    @Resource
    ClientLicenseManager clientLicenseManager;
    @Value(value="${cpislicense.client.remindDays:7}")
    private long remindDays;
    @Value(value="${spring.application.name}")
    private String serverName;

    @ApiOperation(value="\u83b7\u53d6\u5230\u671f\u65f6\u95f4", notes="\u83b7\u53d6\u5230\u671f\u65f6\u95f4", httpMethod="GET")
    @GetMapping(value={"/getDate"})
    public R<Date> getDate() {
        LicenseContent licenseContent = this.clientLicenseManager.getLicenseContent();
        if (licenseContent != null) {
            Date notAfter = licenseContent.getNotAfter();
            return R.ok((Object)notAfter);
        }
        return R.failed((String)"\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25");
    }

    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u5230\u671f\u65f6\u95f4\u4fe1\u606f\u63d0\u793a\u8bed", notes="\u83b7\u53d6\u6388\u6743\u5230\u671f\u65f6\u95f4\u4fe1\u606f\u63d0\u793a\u8bed", httpMethod="GET")
    @GetMapping(value={"/getLicenseMsg"})
    public R<?> getLicenseMsg() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        LicenseContent licenseContent = this.clientLicenseManager.getLicenseContent();
        if (licenseContent != null) {
            Date notAfter = licenseContent.getNotAfter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            returnMap.put("expireTime", sdf.format(notAfter));
            long nowTime = System.currentTimeMillis();
            long endTime = notAfter.getTime();
            if (nowTime > endTime) {
                returnMap.put("isExpire", "true");
                returnMap.put("msg", this.serverName + "\u670d\u52a1\u6388\u6743\u5df2\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u670d\u52a1\u5546\uff01");
                return R.ok(returnMap);
            }
            long midTime = (endTime - nowTime) / 1000L / 60L / 60L / 24L;
            if (midTime > this.remindDays) {
                returnMap.put("isExpire", "false");
                return R.ok(returnMap);
            }
            long hh = (endTime - nowTime) / 1000L / 60L / 60L % 24L;
            int day = (int)midTime;
            returnMap.put("isExpire", "false");
            returnMap.put("msg", this.serverName + "\u670d\u52a1\u6388\u6743\u8fd8\u6709" + day + "\u5929" + hh + "\u65f6\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u670d\u52a1\u5546\uff01");
            return R.ok(returnMap);
        }
        returnMap.put("isExpire", "true");
        returnMap.put("msg", this.serverName + "\u670d\u52a1\u6388\u6743\u65e5\u671f\u83b7\u53d6\u5f02\u5e38");
        return R.ok(returnMap);
    }
}

