/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.i18n.utils;

import com.cpis.i18n.filter.I18nFilter;
import com.cpis.i18n.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@ComponentScan
@Configuration
public class LocaleConfigurer
extends WebMvcConfigurerAdapter {
    private static Logger logger = LoggerFactory.getLogger(LocaleConfigurer.class);
    @Value(value="${spring.messages.default-locale}")
    private String defaultLocale;
    @Value(value="${spring.messages.locale-change-param-name}")
    private String localeChangeParamName;

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        if (this.localeChangeParamName == null) {
            this.localeChangeParamName = "lang";
        }
        logger.debug("localeChangeParamName is {}.", (Object)this.localeChangeParamName);
        localeChangeInterceptor.setParamName(this.localeChangeParamName);
        return localeChangeInterceptor;
    }

    @Bean
    public LocaleResolver localeResolver() {
        List locales;
        List<Locale> availableLocales;
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        Locale defaultLo = Locale.SIMPLIFIED_CHINESE;
        if (StringUtils.isNotEmpty(this.defaultLocale) && (availableLocales = Arrays.asList(Locale.getAvailableLocales())).size() > 0 && (locales = availableLocales.stream().filter(one -> this.defaultLocale.equalsIgnoreCase(one.toString())).collect(Collectors.toList())).size() > 0) {
            defaultLo = (Locale)locales.get(0);
        }
        localeResolver.setDefaultLocale(defaultLo);
        return localeResolver;
    }

    @Bean
    public I18nFilter i18nFilter() {
        return new I18nFilter();
    }

    @Bean(name={"messageSource"})
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageBundle = new ReloadableResourceBundleMessageSource();
        messageBundle.setBasenames(new String[]{"classpath:i18n/messages", "classpath:i18n/common"});
        messageBundle.setDefaultEncoding("UTF-8");
        return messageBundle;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }
}

