/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.i18n.filter;

import com.cpis.i18n.utils.LocaleMessageSource;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

@WebFilter(filterName="i18nFilter", urlPatterns={"/*"})
public class I18nFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(I18nFilter.class);
    @Autowired
    private LocaleMessageSource localeMessageSource;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            String lang = httpRequest.getHeader("lang");
            logger.debug("the parameter lang is {}.", (Object)lang);
            if (null != lang) {
                LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)httpRequest);
                logger.debug("the localeResolver is {}.", (Object)localeResolver);
                if (localeResolver == null) {
                    if ("zh_cn".equalsIgnoreCase(lang)) {
                        httpRequest.getSession().setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)new Locale("zh", "CN"));
                    } else if ("en_us".equalsIgnoreCase(lang)) {
                        httpRequest.getSession().setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)new Locale("en", "US"));
                    }
                } else if ("zh_cn".equalsIgnoreCase(lang)) {
                    localeResolver.setLocale(httpRequest, httpResponse, new Locale("zh", "CN"));
                } else if ("en_us".equalsIgnoreCase(lang)) {
                    localeResolver.setLocale(httpRequest, httpResponse, new Locale("en", "US"));
                }
            }
        }
        catch (Exception e) {
            logger.error("i18n filter error:", (Throwable)e);
        }
        logger.debug("language ==> {}", (Object)LocaleContextHolder.getLocale().getLanguage());
        logger.debug("language ==> {}", (Object)this.localeMessageSource.getMessage("lang.swith"));
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

