/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.fegin;

import com.alibaba.druid.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"DEBUG_LOG");
    static final int CONNECT_TIMEOUT_MILLES = 5000;
    static final Charset ENCODING = Charset.forName("UTF-8");
    public static final String HTTP_GET = "GET";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_DELETE = "DELETE";
    static final String[] METHODS = new String[]{"GET", "PUT", "POST", "DELETE"};

    private static HttpURLConnection createConnection(String url, int connectTimeout) throws IOException {
        logger.debug("http connection url:" + url);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        HttpUtils.setConfig(conn);
        conn.setConnectTimeout(connectTimeout > 0 ? connectTimeout : 5000);
        return conn;
    }

    private static void setMethod(HttpURLConnection conn, String method) throws IOException {
        conn.setRequestMethod(method);
    }

    public static HttpResponse doGet(String url, Map<String, String> headers, Map<String, String> params, String content) throws IOException {
        return HttpUtils.doHttp(url, HTTP_GET, headers, params, content, 5000);
    }

    public static HttpResponse doPost(String url, Map<String, String> headers, Map<String, String> params, String content) throws IOException {
        return HttpUtils.doHttp(url, HTTP_POST, headers, params, content, 5000);
    }

    public static HttpResponse doPut(String url, Map<String, String> headers, Map<String, String> params, String content) throws IOException {
        return HttpUtils.doHttp(url, HTTP_PUT, headers, params, content, 5000);
    }

    public static HttpResponse doDelete(String url, Map<String, String> headers, Map<String, String> params, String content) throws IOException {
        return HttpUtils.doHttp(url, HTTP_DELETE, headers, params, content, 5000);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpResponse doHttp(String url, String method, Map<String, String> headers, Map<String, String> params, String content, int connectTimeout) throws IOException {
        HttpResponse httpResponse;
        HttpURLConnection conn = null;
        HttpResponse response = new HttpResponse();
        try {
            conn = HttpUtils.createConnection(HttpUtils.setParams(url, params), connectTimeout);
            HttpUtils.setMethod(conn, method);
            HttpUtils.setHeaders(conn, headers);
            conn.connect();
            HttpUtils.output(conn, content);
            response.setCode(conn.getResponseCode());
            response.setMessage(conn.getResponseMessage());
            response.setContent(HttpUtils.input(conn));
            httpResponse = response;
        }
        catch (SocketTimeoutException ste) {
            try {
                throw ste;
                catch (IOException ioe) {
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                HttpUtils.connClose(conn);
                throw throwable;
            }
        }
        HttpUtils.connClose(conn);
        return httpResponse;
    }

    private static void connClose(HttpURLConnection conn) {
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String input(HttpURLConnection conn) throws IOException {
        char[] cbuf = new char[8192];
        StringBuilder buf = new StringBuilder();
        int status = conn.getResponseCode();
        InputStream in = null;
        BufferedReader reader = null;
        try {
            in = conn.getErrorStream();
            if (in == null && status < 400) {
                in = conn.getInputStream();
            }
            if (in != null) {
                int len;
                reader = new BufferedReader(new InputStreamReader(in, ENCODING));
                while ((len = reader.read(cbuf)) > 0) {
                    buf.append(cbuf, 0, len);
                }
            } else {
                logger.info("\u8bfb\u53d6\u670d\u52a1\u7aef\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\u6216\u5f02\u5e38\uff0cInputStream=null!", (Object)conn.getPermission());
            }
        }
        catch (IOException ioe) {
            logger.error("\u8bfb\u53d6\u670d\u52a1\u7aef\u54cd\u5e94\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0cerror:", (Throwable)ioe);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return buf.toString();
    }

    private static void output(HttpURLConnection conn, String content) throws IOException {
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        OutputStream out = conn.getOutputStream();
        try {
            out.write(content.getBytes(ENCODING));
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private static void setConfig(HttpURLConnection conn) {
        conn.setUseCaches(false);
        conn.setInstanceFollowRedirects(true);
        conn.setRequestProperty("Connection", "close");
        conn.setDoOutput(true);
        conn.setDoInput(true);
    }

    private static void setHeaders(HttpURLConnection conn, Map<String, String> headers) {
        if (headers == null || headers.size() <= 0) {
            return;
        }
        headers.forEach((k, v) -> conn.setRequestProperty((String)k, (String)v));
    }

    private static String setParams(String url, Map<String, String> params) {
        if (params == null || params.size() <= 0) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        sb.append("?");
        params.forEach((k, v) -> {
            try {
                sb.append((String)k).append("=").append(URLEncoder.encode(v, ENCODING.toString())).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("set url param error", (Throwable)uee);
            }
        });
        return sb.substring(0, sb.length() - 1);
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wd", "HttpURLConnection");
        HttpResponse response = HttpUtils.doGet("http://www.baidu.com/s", null, params, null);
        System.out.println(response.getContent());
    }

    public static class HttpResponse {
        public int code;
        public String message;
        public String content;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

