/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.exception.configuration;

import com.cpis.exception.config.CpisR;
import com.cpis.exception.config.CpisStateEnum;
import com.cpis.exception.configuration.GlobalSqlExceptionHandler;
import com.cpis.exception.utils.RUtil;
import feign.RetryableException;
import io.netty.channel.ConnectTimeoutException;
import java.net.SocketTimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import redis.clients.jedis.exceptions.JedisConnectionException;

@ControllerAdvice
@RestControllerAdvice
public class GlobalTimeOutExceptionHandler
extends GlobalSqlExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalTimeOutExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={SocketTimeoutException.class})
    public CpisR<Object> handleSocketTimeoutException(HttpServletRequest request, SocketTimeoutException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalTimeOutExceptionHandler.getErrorMessage("com.cpis.common.error.third.mw.C0160", CpisStateEnum.C0160), this.getErrorCode(CpisStateEnum.C0160.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={RetryableException.class})
    public CpisR<Object> handleRetryableException(HttpServletRequest request, RetryableException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalTimeOutExceptionHandler.getErrorMessage("com.cpis.common.error.third.mw.C0151", CpisStateEnum.C0151), this.getErrorCode(CpisStateEnum.C0151.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ConnectTimeoutException.class})
    public CpisR<Object> handleConnectTimeoutException(HttpServletRequest request, ConnectTimeoutException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalTimeOutExceptionHandler.getErrorMessage("com.cpis.common.error.third.mw.C0160", CpisStateEnum.C0160), this.getErrorCode(CpisStateEnum.C0160.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={JedisConnectionException.class})
    public CpisR<Object> handleJedisConnectionException(HttpServletRequest request, JedisConnectionException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalTimeOutExceptionHandler.getErrorMessage("com.cpis.common.error.third.mw.C0135", CpisStateEnum.C0135), this.getErrorCode(CpisStateEnum.C0135.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={AmqpTimeoutException.class})
    public CpisR<Object> handleSocketTimeoutException(HttpServletRequest request, AmqpTimeoutException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalTimeOutExceptionHandler.getErrorMessage("com.cpis.common.error.third.mw.C0125", CpisStateEnum.C0125), this.getErrorCode(CpisStateEnum.C0125.getCode()), exception.getMessage());
    }
}

