/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.exception.configuration;

import com.cpis.exception.config.CpisR;
import com.cpis.exception.config.CpisStateEnum;
import com.cpis.exception.configuration.GlobalExceptionHandler;
import com.cpis.exception.utils.RUtil;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ControllerAdvice
@RestControllerAdvice
public class GlobalSqlExceptionHandler
extends GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalSqlExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={SQLException.class})
    public CpisR<Object> handleSQLException(HttpServletRequest request, SQLException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0300", CpisStateEnum.C0300), this.getErrorCode(CpisStateEnum.C0300.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={MyBatisSystemException.class})
    public CpisR<Object> handleMyBatisSystemException(HttpServletRequest request, MyBatisSystemException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0301", CpisStateEnum.C0301), this.getErrorCode(CpisStateEnum.C0301.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BadSqlGrammarException.class})
    public CpisR<Object> handleBadSqlGrammarExceptionException(HttpServletRequest request, BadSqlGrammarException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0304", CpisStateEnum.C0304), this.getErrorCode(CpisStateEnum.C0304.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public CpisR<Object> handleDataIntegrityViolationExceptionException(HttpServletRequest request, DataIntegrityViolationException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0305", CpisStateEnum.C0305), this.getErrorCode(CpisStateEnum.C0305.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={UncategorizedSQLException.class})
    public CpisR<Object> handleUncategorizedSQLException(HttpServletRequest request, UncategorizedSQLException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0306", CpisStateEnum.C0306), this.getErrorCode(CpisStateEnum.C0306.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={CannotGetJdbcConnectionException.class})
    public CpisR<Object> handleCannotGetJdbcConnectionExceptionException(HttpServletRequest request, CannotGetJdbcConnectionException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0307", CpisStateEnum.C0307), this.getErrorCode(CpisStateEnum.C0307.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={IncorrectResultSetColumnCountException.class})
    public CpisR<Object> handleIncorrectResultSetColumnCountException(HttpServletRequest request, IncorrectResultSetColumnCountException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalSqlExceptionHandler.getErrorMessage("com.cpis.common.error.db.C0308", CpisStateEnum.C0308), this.getErrorCode(CpisStateEnum.C0308.getCode()), exception.getMessage());
    }
}

