/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.exception.configuration;

import com.cpis.exception.config.CpisR;
import com.cpis.exception.config.CpisStateEnum;
import com.cpis.exception.utils.RUtil;
import com.cpis.i18n.utils.MessageUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ControllerAdvice
@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    Logger exceptionLog = LoggerFactory.getLogger((String)"EXCEPTION_LOG");
    @Value(value="${pointcut.parameterButton.request:'false'}")
    private String exceptionReqParam;
    @Value(value="${cpis.servercode}")
    private String serverCode;

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public CpisR<Object> handleException(HttpServletRequest request, Exception exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalExceptionHandler.getErrorMessage("com.cpis.common.error.UNKNOW", CpisStateEnum.UNKNOW), this.getErrorCode(CpisStateEnum.UNKNOW.getCode()), exception.getMessage());
    }

    public void outPrintExceptionMessage(HttpServletRequest request, Exception exception) {
        String resquestTime = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(new Date());
        if (request != null) {
            Map<String, String> rtnMap = this.converMap(request.getParameterMap());
            String reqParams = String.valueOf(JSONObject.fromObject(rtnMap));
            this.exceptionLog.error("\u3010time\u3011:{} --- \u3010Class:method\u3011:{} --- \u3010request parameter\u3011:{} --- \u3010exceptionType\u3011:{} --- \u3010exception\u3011:{}", new Object[]{resquestTime, request.getRequestURI(), "false".equals(this.exceptionReqParam) ? "\u8bf7\u6c42\u53c2\u6570\u5173\u95ed" : reqParams, exception.getClass().getName(), this.stackTraceToString(exception.getMessage(), exception.getStackTrace())});
        } else {
            this.exceptionLog.error("\u5f02\u5e38\u4fe1\u606f:", (Throwable)exception);
        }
    }

    public Map<String, String> converMap(Map<String, String[]> paramMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (String key : paramMap.keySet()) {
            rtnMap.put(key, paramMap.get(key)[0]);
        }
        return rtnMap;
    }

    public String stackTraceToString(String exceptionMessage, StackTraceElement[] elements) {
        StringBuffer strbuff = new StringBuffer();
        for (StackTraceElement stet : elements) {
            strbuff.append(stet + "\n");
        }
        String message = exceptionMessage + "\n\t" + strbuff.toString();
        return message;
    }

    public static String getErrorMessage(String message, CpisStateEnum code) {
        String resultMessage = "";
        try {
            resultMessage = MessageUtils.getMessage(message, new Object[0]);
        }
        catch (Exception e) {
            resultMessage = code.getText();
        }
        return resultMessage;
    }

    public String getErrorCode(String code) {
        return this.serverCode + code;
    }
}

