/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.exception.configuration;

import com.alibaba.fastjson.JSONException;
import com.cpis.exception.config.CpisR;
import com.cpis.exception.config.CpisStateEnum;
import com.cpis.exception.configuration.GlobalTimeOutExceptionHandler;
import com.cpis.exception.utils.RUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ControllerAdvice
@RestControllerAdvice
public class GlobalBaseExceptionHandler
extends GlobalTimeOutExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalBaseExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={IOException.class})
    public CpisR<Object> handleIOException(HttpServletRequest request, IOException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0500", CpisStateEnum.C0500), this.getErrorCode(CpisStateEnum.C0500.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ArrayStoreException.class})
    public CpisR<Object> handleArrayStoreExceptionException(HttpServletRequest request, ArrayStoreException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0501", CpisStateEnum.C0501), this.getErrorCode(CpisStateEnum.C0501.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={NullPointerException.class})
    public CpisR<Object> handleNullPointerException(HttpServletRequest request, NullPointerException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0502", CpisStateEnum.C0502), this.getErrorCode(CpisStateEnum.C0502.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ClassNotFoundException.class})
    public CpisR<Object> handleClassNotFoundException(HttpServletRequest request, ClassNotFoundException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0503", CpisStateEnum.C0503), this.getErrorCode(CpisStateEnum.C0503.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ArithmeticException.class})
    public CpisR<Object> handleArithmeticException(HttpServletRequest request, ArithmeticException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0504", CpisStateEnum.C0504), this.getErrorCode(CpisStateEnum.C0504.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ClassCastException.class})
    public CpisR<Object> handleClassCastException(HttpServletRequest request, ClassCastException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0505", CpisStateEnum.C0505), this.getErrorCode(CpisStateEnum.C0505.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={IllegalAccessException.class})
    public CpisR<Object> handleIllegalAccessException(HttpServletRequest request, IllegalAccessException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0506", CpisStateEnum.C0506), this.getErrorCode(CpisStateEnum.C0506.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={IllegalArgumentException.class})
    public CpisR<Object> handleIllegalArgumentException(HttpServletRequest request, IllegalArgumentException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0507", CpisStateEnum.C0507), this.getErrorCode(CpisStateEnum.C0507.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={FileNotFoundException.class})
    public CpisR<Object> handleFileNotFoundException(HttpServletRequest request, FileNotFoundException exception) {
        this.outPrintExceptionMessage(request, exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0508", CpisStateEnum.C0508), this.getErrorCode(CpisStateEnum.C0508.getCode()), exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={JSONException.class})
    public CpisR<Object> handleIllegalAccessException(HttpServletRequest request, JSONException exception) {
        this.outPrintExceptionMessage(request, (Exception)exception);
        return RUtil.resultException(GlobalBaseExceptionHandler.getErrorMessage("com.cpis.common.error.java.C0510", CpisStateEnum.C0510), this.getErrorCode(CpisStateEnum.C0510.getCode()), exception.getMessage());
    }
}

