/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.exception.config;

import com.cpis.exception.config.CpisStateEnum;
import com.cpis.i18n.utils.MessageUtils;
import com.cpis.i18n.utils.StringUtils;
import java.io.Serializable;

public class CpisR<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private T data;
    private String msg;
    private String cpisCause;

    public String getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getCpisCause() {
        return this.cpisCause;
    }

    public CpisR<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public CpisR<T> setCpisCause(String cpisCause) {
        this.cpisCause = cpisCause;
        return this;
    }

    public CpisR<T> setData(T data) {
        this.data = data;
        return this;
    }

    public CpisR<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public static <T> CpisR<T> ok(T data) {
        String aec = "0";
        if (data instanceof Boolean && Boolean.FALSE.equals(data)) {
            aec = "-1";
        }
        return CpisR.restResult(data, aec);
    }

    public static <T> CpisR<T> failed(String msg) {
        return CpisR.restResult(null, "-1", msg);
    }

    public static <T> CpisR<T> restResult(T data, String code) {
        if ("0".equals(code)) {
            return CpisR.restResult(data, code, CpisR.getI18nMessage(CpisStateEnum.SUCCESS));
        }
        return CpisR.restResult(data, code, CpisR.getI18nMessage(CpisStateEnum.UNKNOW));
    }

    private static <T> CpisR<T> restResult(T data, String code, String msg) {
        CpisR<T> apiResult = new CpisR<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public static String getI18nMessage(CpisStateEnum cpisStateEnum) {
        String resultMessage = "";
        if (StringUtils.isEmpty(cpisStateEnum.getMsg())) {
            return cpisStateEnum.getText();
        }
        try {
            resultMessage = MessageUtils.getMessage(cpisStateEnum.getMsg(), new Object[0]);
        }
        catch (Exception e) {
            resultMessage = cpisStateEnum.getText();
        }
        return resultMessage;
    }
}

