/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.cpisImportExport.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.config.ResponseHolder;
import com.cpis.cpisImportExport.io.CpisDoTaskIo;
import com.cpis.cpisImportExport.mapper.CpisDoTaskMapper;
import com.cpis.cpisImportExport.po.CpisDiTaskPo;
import com.cpis.cpisImportExport.po.CpisDoTaskPo;
import com.cpis.cpisImportExport.service.CpisDoTaskService;
import com.cpis.fegin.FeginExtendService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class CpisDoTaskServiceImpl
extends ServiceImpl<CpisDoTaskMapper, CpisDoTaskPo>
implements CpisDoTaskService {
    @Resource
    FeginExtendService feginExtendService;

    @Override
    public Page<CpisDoTaskPo> listByPage(CpisDoTaskIo cpisDoTaskIo) {
        Page page = cpisDoTaskIo.getPage();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public String writeExcel(CpisDiTaskPo cpisDiTaskPo, Class<?> clazz) {
        String exceptFileId = null;
        try {
            List cpisDoTaskPos = this.list((Wrapper)new QueryWrapper().eq((Object)"task_id", (Object)cpisDiTaskPo.getId()));
            List exportVos = cpisDoTaskPos.stream().map(cpisDoTaskPo -> {
                String json = cpisDoTaskPo.getExceptData();
                JSONObject jsonObj = (JSONObject)JSON.parse((String)json);
                Object exportVo = JSONObject.toJavaObject((JSON)jsonObj, (Class)clazz);
                try {
                    Field fNo = exportVo.getClass().getDeclaredField("lineNo");
                    fNo.setAccessible(true);
                    fNo.set(exportVo, cpisDoTaskPo.getLineNo());
                    Field fDesc = exportVo.getClass().getDeclaredField("exceptDesc");
                    fDesc.setAccessible(true);
                    fDesc.set(exportVo, cpisDoTaskPo.getExceptDesc());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                return exportVo;
            }).collect(Collectors.toList());
            if (!exportVos.isEmpty()) {
                Map<String, Object> map;
                File tempDirectory = FileUtils.getTempDirectory();
                File file = new File(tempDirectory, cpisDiTaskPo.getId() + ".xlsx");
                ((ExcelWriterBuilder)EasyExcel.write((String)file.getAbsolutePath()).head(CpisDoTaskServiceImpl.head(clazz))).sheet("\u5f02\u5e38\u6570\u636e").doWrite(exportVos);
                ResponseHolder responseHolder = this.feginExtendService.uploadExtend(this.getMultipartFile(file));
                if (responseHolder.getState() == 200 && !(map = responseHolder.getData()).isEmpty()) {
                    exceptFileId = map.get("id").toString();
                    this.remove((Wrapper)new QueryWrapper().eq((Object)"task_id", (Object)cpisDiTaskPo.getId()));
                }
                if (file.exists()) {
                    boolean bl = file.delete();
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return exceptFileId;
    }

    private static List<List<String>> head(Class<?> clazz) {
        Field[] fields;
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean hasExcelProperty = field.isAnnotationPresent(ExcelProperty.class);
            String col = hasExcelProperty ? field.getAnnotation(ExcelProperty.class).value()[0] : field.getName();
            ArrayList<String> head = new ArrayList<String>();
            head.add(col);
            list.add(head);
        }
        return list;
    }

    private static List<List<Object>> dataList(Class<?> clazz, List objectList) {
        Field[] fields;
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String col = field.getName();
            fieldList.add(col);
        }
        List<Map<String, Object>> mapList = CpisDoTaskServiceImpl.transObject(objectList);
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (Map<String, Object> map : mapList) {
            ArrayList<Object> data = new ArrayList<Object>();
            for (String field : fieldList) {
                data.add(map.get(field));
            }
            list.add(data);
        }
        return list;
    }

    static List<Map<String, Object>> transObject(List<T> objectList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try {
            for (T obj : objectList) {
                ObjectMapper mapper = new ObjectMapper();
                Map m = (Map)mapper.readValue(mapper.writeValueAsString((Object)obj), Map.class);
                mapList.add(m);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mapList;
    }

    public MultipartFile getMultipartFile(File file) {
        DiskFileItem item = new DiskFileItem("file", "multipart/form-data", true, file.getName(), (int)file.length(), file.getParentFile());
        try {
            OutputStream os = item.getOutputStream();
            os.write(FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile((FileItem)item);
    }
}

