/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.cpisImportExport.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cpis.config.ResponseHolder;
import com.cpis.cpisImportExport.api.entity.ExecuteResult;
import com.cpis.cpisImportExport.io.CpisDiTaskIo;
import com.cpis.cpisImportExport.mapper.CpisDiTaskMapper;
import com.cpis.cpisImportExport.po.CpisDiTaskPo;
import com.cpis.cpisImportExport.service.CpisDiTaskService;
import com.cpis.cpisImportExport.service.CpisDoTaskService;
import com.cpis.fegin.FeginExtendService;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CpisDiTaskServiceImpl
extends ServiceImpl<CpisDiTaskMapper, CpisDiTaskPo>
implements CpisDiTaskService {
    @Resource
    CpisDoTaskService cpisDoTaskService;
    @Resource
    FeginExtendService feginExtendService;

    @Override
    public Page<CpisDiTaskPo> listByPage(CpisDiTaskIo cpisDiTaskIo) {
        Page page = cpisDiTaskIo.getPage();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((CharSequence)cpisDiTaskIo.getTaskName())) {
            queryWrapper.eq((Object)"task_name", (Object)cpisDiTaskIo.getTaskName());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisDiTaskIo.getDataCode())) {
            queryWrapper.eq((Object)"data_code", (Object)cpisDiTaskIo.getDataCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisDiTaskIo.getTaskState())) {
            queryWrapper.eq((Object)"task_state", (Object)cpisDiTaskIo.getTaskState());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisDiTaskIo.getExecNum())) {
            queryWrapper.eq((Object)"exec_num", (Object)cpisDiTaskIo.getExecNum());
        }
        if (StringUtil.isNotEmpty((CharSequence)cpisDiTaskIo.getTotalNum())) {
            queryWrapper.eq((Object)"total_num", (Object)cpisDiTaskIo.getTotalNum());
        }
        queryWrapper.orderByDesc((Object)"create_time");
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void doAfterAllProcessed(String taskId, Class<?> clazz) {
        CpisDiTaskPo cpisDiTaskPo = (CpisDiTaskPo)this.getById((Serializable)((Object)taskId));
        String exceptFileId = this.cpisDoTaskService.writeExcel(cpisDiTaskPo, clazz);
        cpisDiTaskPo.setTaskState(20);
        cpisDiTaskPo.setExecUpdateTime(new Date());
        cpisDiTaskPo.setExceptFileId(exceptFileId);
        this.updateById(cpisDiTaskPo);
        this.updateExtend(cpisDiTaskPo);
    }

    @Override
    public void doFailProcessed(String taskId, Class<?> clazz) {
        CpisDiTaskPo cpisDiTaskPo = (CpisDiTaskPo)this.getById((Serializable)((Object)taskId));
        String exceptFileId = this.cpisDoTaskService.writeExcel(cpisDiTaskPo, clazz);
        cpisDiTaskPo.setTaskState(30);
        cpisDiTaskPo.setExecUpdateTime(new Date());
        cpisDiTaskPo.setExceptFileId(exceptFileId);
        this.updateById(cpisDiTaskPo);
        this.updateExtend(cpisDiTaskPo);
    }

    public void updateExtend(CpisDiTaskPo cpisDiTaskPo) {
        try {
            ResponseHolder responseHolder = this.feginExtendService.syncState(cpisDiTaskPo);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public List<CpisDiTaskPo> getTask() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_state", (Object)20);
        queryWrapper.lt((Object)"exec_num", (Object)3);
        queryWrapper.or(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper.eq((Object)"task_state", (Object)0);
        });
        queryWrapper.orderByDesc((Object)"create_time");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CpisDiTaskPo> getFailingTask() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_state", (Object)20);
        queryWrapper.lt((Object)"exec_num", (Object)3);
        queryWrapper.or(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"task_state", (Object)30)).isNull((Object)"except_file_id");
        });
        queryWrapper.orderByDesc((Object)"create_time");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, String> importSyncState(CpisDiTaskPo cpisDiTaskPo) {
        CpisDiTaskPo localPo = (CpisDiTaskPo)this.getById((Serializable)((Object)cpisDiTaskPo.getId()));
        ExecuteResult result = new ExecuteResult("true", "false", "");
        if (localPo != null) {
            if (localPo.getExecNum() >= 3 && localPo.getTaskState() == 10) {
                result.setIsExec("false");
                result.setExecState("30");
                localPo.setTaskState(30);
                this.updateExtend(localPo);
            } else if (localPo.getTaskState() == 0) {
                long createTime = localPo.getCreateTime().getTime();
                long now = System.currentTimeMillis();
                if (now - createTime >= 1800000L) {
                    result.setIsExec("true");
                    result.setExecState("0");
                }
            } else if (localPo.getTaskState() == 10 && localPo.getExecNum() < 3 && localPo.getExecUpdateTime().getTime() + (long)(localPo.getMinTime() * 1000) <= System.currentTimeMillis() && localPo.getExecUpdateTime().getTime() + 3600000L >= System.currentTimeMillis()) {
                result.setIsExec("true");
                result.setExecState("10");
            }
        } else {
            result.setIsAccess("false");
        }
        return BeanUtils.describe((Object)result);
    }
}

