/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.changeLog;

import com.alibaba.fastjson.JSONObject;
import com.cpis.changeLog.po.CpisBusinessLogPo;
import com.cpis.changeLog.service.CpisBusinessLogService;
import com.cpis.fegin.FeginExtendService;
import com.cpis.rabbitmq.producer.CpisBusinessLogQueueProducer;
import com.cpis.rabbitmq.producer.ICpisQueueProducer;
import com.lc.ibps.base.saas.context.TenantContext;
import com.lc.ibps.cloud.entity.APIResult;
import com.lc.ibps.cloud.mq.core.model.DefaultMessage;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ChangeLogUtil {
    private static FeginExtendService feginPushService;
    private static CpisBusinessLogService cpisBusinessLogService;
    private static ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducer;
    @Resource
    private FeginExtendService getFeginPushServiceTemp;
    @Resource
    private CpisBusinessLogService cpisBusinessLogServiceTemp;
    @Autowired
    @Qualifier(value="CpisBusinessLogQueueProducer")
    private ICpisQueueProducer<DefaultMessage<?>> cpisMessageQueueProducerTemp = new CpisBusinessLogQueueProducer();

    @PostConstruct
    public void init() {
        feginPushService = this.getFeginPushServiceTemp;
        cpisBusinessLogService = this.cpisBusinessLogServiceTemp;
        cpisMessageQueueProducer = this.cpisMessageQueueProducerTemp;
    }

    public static void writeBusinessChangeLog(String bizType, String changeType, String businessId, String changeuser, Date changeTime, String companyId, JSONObject bizBean) {
        APIResult r = feginPushService.getByBusinessType(bizType);
        if (r.getState() == 0) {
            CpisBusinessLogPo cpisBusinessLogPo = new CpisBusinessLogPo();
            cpisBusinessLogPo.setBusinessType(bizType);
            cpisBusinessLogPo.setBusinessInfo(bizBean.toJSONString());
            cpisBusinessLogPo.setChangeTime(changeTime);
            cpisBusinessLogPo.setBusinessId(businessId);
            cpisBusinessLogPo.setChangeType(changeType);
            cpisBusinessLogPo.setChangeuser(changeuser);
            cpisBusinessLogPo.setCompanyId(companyId);
            cpisBusinessLogService.save(cpisBusinessLogPo);
        }
    }

    public static void sendMq(int intervalSecond) {
        List<CpisBusinessLogPo> list = cpisBusinessLogService.getSendList(intervalSecond);
        list.stream().forEach(cpisBusinessLogPo -> ChangeLogUtil.sendMq(cpisBusinessLogPo));
    }

    private static void sendMq(CpisBusinessLogPo cpisBusinessLogPo) {
        DefaultMessage message = new DefaultMessage();
        message.setTenantId(TenantContext.getCurrentTenantId());
        message.setMessageType("change-log");
        message.setRouting("cpis-provider-push");
        message.setExchange("ibps.exchange.cpis.message");
        message.setQueue("cpis-provider-push");
        message.setSenderId(cpisBusinessLogPo.getLogId());
        message.setData((Serializable)cpisBusinessLogPo);
        cpisMessageQueueProducer.push(message);
    }

    static {
        cpisMessageQueueProducer = new CpisBusinessLogQueueProducer();
    }
}

