/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.bizCode.processor.serialNumberRule;

import com.alibaba.fastjson.JSONObject;
import com.cpis.bizCode.BizCodeUtil;
import com.cpis.bizCode.processor.ProcessFactory;
import com.cpis.bizCode.processor.Processor;
import com.cpis.bizCode.processor.format.FormatUtil;
import com.cpis.bizCode.processor.serialNumber.CpisSerialPo;
import com.cpis.bizCode.processor.serialNumberRule.CpisBizFormSerialRulePo;
import com.lc.ibps.cloud.redis.utils.RedisUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SerialNumRuleProcess
implements Processor {
    @Override
    public String processor(JSONObject jsonObject, String ruleStr) {
        CpisSerialPo cpisSerialPo;
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        String snId = map.get("snrule");
        String value = "";
        CpisBizFormSerialRulePo rulePo = (CpisBizFormSerialRulePo)BizCodeUtil.feginExtendService.getBizFormSerialRule(snId).getData();
        String serialRuleKey = rulePo.getSerialRuleKey();
        List<String> serialRuleList = BizCodeUtil.spiltData(serialRuleKey);
        ArrayList<String> ruleList = new ArrayList<String>();
        serialRuleList.forEach(rule -> ruleList.add(ProcessFactory.getInstance(rule.substring(0, rule.indexOf(":"))).processor(jsonObject, (String)rule)));
        snId = snId + "-" + BizCodeUtil.solve(serialRuleKey, ruleList);
        List list = new ArrayList();
        if (RedisUtil.redisTemplate().hasKey((Object)("snrule-" + snId)).booleanValue()) {
            list = (List)RedisUtil.redisTemplate.opsForValue().get((Object)("snrule-" + snId));
        }
        if (list.isEmpty()) {
            list = (List)BizCodeUtil.feginExtendService.getNewSerialValue(snId).getData();
        }
        if ((cpisSerialPo = (CpisSerialPo)list.get(0)).getCycleState() == 1 && new Date().after(cpisSerialPo.getEndTime())) {
            list = (List)BizCodeUtil.feginExtendService.getSerialValue(snId).getData();
            cpisSerialPo = (CpisSerialPo)list.get(0);
        }
        value = cpisSerialPo.getCurValue().toString();
        if (map.containsKey("format")) {
            value = FormatUtil.formatString(map, value);
        }
        list.remove(0);
        RedisUtil.redisTemplate.opsForValue().set((Object)("snrule-" + snId), (Object)((Serializable)((Object)list)));
        return value;
    }

    @Override
    public List<String> processor(JSONObject jsonObject, String ruleStr, Integer num) {
        CpisSerialPo cpisSerialPo;
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        String snId = map.get("snrule");
        CpisBizFormSerialRulePo rulePo = (CpisBizFormSerialRulePo)BizCodeUtil.feginExtendService.getBizFormSerialRule(snId).getData();
        String serialRuleKey = rulePo.getSerialRuleKey();
        List<String> serialRuleList = BizCodeUtil.spiltData(serialRuleKey);
        ArrayList<String> ruleList = new ArrayList<String>();
        serialRuleList.forEach(rule -> ruleList.add(ProcessFactory.getInstance(rule.substring(0, rule.indexOf(":"))).processor(jsonObject, (String)rule)));
        snId = snId + BizCodeUtil.solve(serialRuleKey, ruleList);
        ArrayList<String> result = new ArrayList<String>();
        List list = new ArrayList();
        if (RedisUtil.redisTemplate().hasKey((Object)("snrule-" + snId)).booleanValue()) {
            list = (List)RedisUtil.redisTemplate.opsForValue().get((Object)("snrule-" + snId));
        }
        if (list.isEmpty()) {
            list = (List)BizCodeUtil.feginExtendService.getNewSerialValue(snId).getData();
        }
        if ((cpisSerialPo = (CpisSerialPo)list.get(0)).getCycleState() == 1 && new Date().after(cpisSerialPo.getEndTime())) {
            list = (List)BizCodeUtil.feginExtendService.getNewSerialValue(snId).getData();
        }
        if (list.size() >= num) {
            for (int i = 0; i < num; ++i) {
                String value = ((CpisSerialPo)list.get(i)).getCurValue().toString();
                if (map.containsKey("format")) {
                    value = FormatUtil.formatString(map, value);
                }
                list.remove(i);
                result.add(value);
            }
        } else {
            list.addAll((Collection)BizCodeUtil.feginExtendService.getNewBatchSerial(snId, num).getData());
            if (list.size() >= num) {
                for (int i = 0; i < num; ++i) {
                    String value = ((CpisSerialPo)list.get(i)).getCurValue().toString();
                    if (map.containsKey("format")) {
                        value = FormatUtil.formatString(map, value);
                    }
                    list.remove(i);
                    result.add(value);
                }
            }
        }
        RedisUtil.redisTemplate.opsForValue().set((Object)("snrule-" + snId), (Object)((Serializable)((Object)list)));
        return result;
    }
}

