/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.bizCode.processor.serialNumber;

import com.alibaba.fastjson.JSONObject;
import com.cpis.bizCode.BizCodeUtil;
import com.cpis.bizCode.processor.Processor;
import com.cpis.bizCode.processor.format.FormatUtil;
import com.cpis.bizCode.processor.serialNumber.CpisSerialPo;
import com.lc.ibps.cloud.redis.utils.RedisUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SeriaNumProcess
implements Processor {
    @Override
    public String processor(JSONObject jsonObject, String ruleStr) {
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        String snId = map.get("sn");
        String snRedisKey = "Platform:sn:" + snId;
        if (RedisUtil.redisTemplate().hasKey((Object)("sn-" + snId)).booleanValue()) {
            List list = (List)RedisUtil.redisTemplate.opsForValue().get((Object)("sn-" + snId));
            for (CpisSerialPo data : list) {
                RedisUtil.redisTemplate.opsForList().rightPush((Object)snRedisKey, (Object)data);
            }
            RedisUtil.redisTemplate().delete((Object)("sn-" + snId));
        }
        String value = "";
        CpisSerialPo cpisSerialPo = new CpisSerialPo();
        if (RedisUtil.redisTemplate().hasKey((Object)snRedisKey).booleanValue()) {
            cpisSerialPo = (CpisSerialPo)RedisUtil.redisTemplate.opsForList().leftPop((Object)snRedisKey);
            value = this.getSn(cpisSerialPo, snId, 0);
        } else {
            this.pushSnData(snId);
            if (!RedisUtil.redisTemplate().hasKey((Object)snRedisKey).booleanValue()) {
                return "";
            }
            cpisSerialPo = (CpisSerialPo)RedisUtil.redisTemplate.opsForList().leftPop((Object)snRedisKey);
            value = this.getSn(cpisSerialPo, snId, 0);
        }
        if (map.containsKey("format")) {
            value = FormatUtil.formatString(map, value);
        }
        return value;
    }

    public String getSn(CpisSerialPo cpisSerialPo, String snId, Integer total) {
        String snRedisKey = "Platform:sn:" + snId;
        if (cpisSerialPo == null || cpisSerialPo.getCurValue() == null) {
            this.pushSnData(snId);
            if (!RedisUtil.redisTemplate().hasKey((Object)snRedisKey).booleanValue()) {
                return "";
            }
            cpisSerialPo = (CpisSerialPo)RedisUtil.redisTemplate.opsForList().leftPop((Object)snRedisKey);
        }
        String redisKey = "Platform:sn:" + snId + ":value" + cpisSerialPo.getCurValue();
        if (RedisUtil.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)0).booleanValue()) {
            RedisUtil.stringRedisTemplate.expire((Object)redisKey, 300L, TimeUnit.SECONDS);
            if (cpisSerialPo.getCycleState() == 1 && new Date().after(cpisSerialPo.getEndTime())) {
                this.pushSnData(snId);
                if (!RedisUtil.redisTemplate().hasKey((Object)snRedisKey).booleanValue()) {
                    return "";
                }
                cpisSerialPo = (CpisSerialPo)RedisUtil.redisTemplate.opsForList().leftPop((Object)snRedisKey);
            }
            return cpisSerialPo.getCurValue().toString();
        }
        CpisSerialPo nextCpisSerialPo = (CpisSerialPo)RedisUtil.redisTemplate.opsForList().leftPop((Object)snRedisKey);
        if ((total = Integer.valueOf(total + 1)) < 10) {
            return this.getSn(nextCpisSerialPo, snId, total);
        }
        return "";
    }

    public void pushSnData(String snId) {
        List cpisSerialListValid = (List)BizCodeUtil.feginExtendService.getSerialValue(snId).getData();
        String snRedisKey = "Platform:sn:" + snId;
        for (CpisSerialPo data : cpisSerialListValid) {
            RedisUtil.redisTemplate.opsForList().rightPush((Object)snRedisKey, (Object)data);
        }
    }

    @Override
    public List<String> processor(JSONObject jsonObject, String ruleStr, Integer num) {
        CpisSerialPo cpisSerialPo;
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        String snId = map.get("sn");
        ArrayList<String> result = new ArrayList<String>();
        List list = new ArrayList();
        if (RedisUtil.redisTemplate().hasKey((Object)("sn-" + snId)).booleanValue()) {
            list = (List)RedisUtil.redisTemplate.opsForValue().get((Object)("sn-" + snId));
        }
        if (list.isEmpty()) {
            list = (List)BizCodeUtil.feginExtendService.getSerialValue(snId).getData();
        }
        if ((cpisSerialPo = (CpisSerialPo)list.get(0)).getCycleState() == 1 && new Date().after(cpisSerialPo.getEndTime())) {
            list = (List)BizCodeUtil.feginExtendService.getSerialValue(snId).getData();
        }
        if (list.size() >= num) {
            for (int i = 0; i < num; ++i) {
                String value = ((CpisSerialPo)list.get(i)).getCurValue().toString();
                if (map.containsKey("format")) {
                    value = FormatUtil.formatString(map, value);
                }
                list.remove(i);
                result.add(value);
            }
        } else {
            list.addAll((Collection)BizCodeUtil.feginExtendService.getBatchSerial(snId, num).getData());
            if (list.size() >= num) {
                for (int i = 0; i < num; ++i) {
                    String value = ((CpisSerialPo)list.get(i)).getCurValue().toString();
                    if (map.containsKey("format")) {
                        value = FormatUtil.formatString(map, value);
                    }
                    list.remove(i);
                    result.add(value);
                }
            }
        }
        RedisUtil.redisTemplate.opsForValue().set((Object)("sn-" + snId), (Object)((Serializable)((Object)list)));
        return result;
    }
}

