/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.bizCode.processor.randomNumber;

import com.alibaba.fastjson.JSONObject;
import com.cpis.bizCode.BizCodeUtil;
import com.cpis.bizCode.processor.Processor;
import com.cpis.bizCode.processor.format.FormatUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandNumProcess
implements Processor {
    @Override
    public String processor(JSONObject jsonObject, String ruleStr) {
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        int rand = Integer.parseInt(map.get("rand"));
        String value = this.getRand(rand);
        if (map.containsKey("format")) {
            return FormatUtil.formatString(map, value);
        }
        return value;
    }

    @Override
    public List<String> processor(JSONObject jsonObject, String ruleStr, Integer num) {
        HashSet<String> resultTemp = new HashSet<String>();
        Map<String, String> map = BizCodeUtil.StringToMap(ruleStr);
        int rand = Integer.parseInt(map.get("rand"));
        int total = num * 10;
        while (resultTemp.size() < num) {
            String value = this.getRand(rand);
            if (map.containsKey("format")) {
                value = FormatUtil.formatString(map, value);
                resultTemp.add(value);
            }
            if (--total != 0) continue;
            break;
        }
        ArrayList<String> result = new ArrayList<String>(resultTemp);
        return result;
    }

    private String getRand(int rand) {
        String code = "";
        Random ran = new Random();
        for (int i = 0; i < rand; ++i) {
            int t = ran.nextInt(10);
            code = code + t;
        }
        return code;
    }
}

