/*
 * Decompiled with CFR 0.152.
 */
package com.cpis.bizCode;

import com.alibaba.fastjson.JSONObject;
import com.cpis.bizCode.processor.BizCodeConfig;
import com.cpis.bizCode.processor.CpisBizCodeConfigPo;
import com.cpis.bizCode.processor.ProcessFactory;
import com.cpis.fegin.FeginExtendService;
import com.cpis.fegin.FeginPlatformService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BizCodeUtil {
    public static FeginExtendService feginExtendService;
    public static FeginPlatformService feginPlatformService;
    @Resource
    private FeginPlatformService feginPlatformServiceTemp;
    @Resource
    private FeginExtendService feginExtendServiceTemp;

    @PostConstruct
    public void init() {
        feginExtendService = this.feginExtendServiceTemp;
        feginPlatformService = this.feginPlatformServiceTemp;
    }

    public static String getBizCode(String ruleStr) {
        return BizCodeUtil.process(null, ruleStr);
    }

    public static String getBizCode(JSONObject jsonObject, String ruleStr) {
        return BizCodeUtil.process(jsonObject, ruleStr);
    }

    public static List<String> getBizCode(String ruleStr, int num) {
        return BizCodeUtil.process(null, ruleStr, num);
    }

    public static List<String> getBizCode(JSONObject jsonObject, String ruleStr, int num) {
        return BizCodeUtil.process(jsonObject, ruleStr, num);
    }

    public static CpisBizCodeConfigPo getCpisBizCodeConfig(String procDefKey) {
        return BizCodeConfig.getCpisBizCodeConfig(procDefKey);
    }

    public static List<String> spiltData(String ruleStr) {
        ArrayList<String> data = new ArrayList<String>();
        while (ruleStr.length() > 0) {
            int index1 = ruleStr.indexOf("{");
            if (index1 != -1) {
                int index2 = ruleStr.indexOf("}", index1);
                if (index2 != -1) {
                    String str3 = ruleStr.substring(index1 + 1, index2);
                    data.add(str3);
                    ruleStr = ruleStr.substring(index2 + 1, ruleStr.length());
                    continue;
                }
                return data;
            }
            return data;
        }
        return data;
    }

    public static String process(JSONObject jsonObject, String ruleStr) {
        ArrayList<String> value = new ArrayList<String>();
        List<String> data = BizCodeUtil.spiltData(ruleStr);
        data.forEach(str -> value.add(ProcessFactory.getInstance(str.substring(0, str.indexOf(":"))).processor(jsonObject, (String)str)));
        return BizCodeUtil.solve(ruleStr, value);
    }

    public static List<String> process(JSONObject jsonObject, String ruleStr, Integer num) {
        ArrayList<String> value = new ArrayList<String>();
        List<String> data = BizCodeUtil.spiltData(ruleStr);
        data.forEach(str -> value.addAll(ProcessFactory.getInstance(str.substring(0, str.indexOf(":"))).processor(jsonObject, (String)str, num)));
        return BizCodeUtil.solveList(ruleStr, value);
    }

    public static Map<String, String> StringToMap(String ruleStr) {
        String[] data;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : data = ruleStr.split("#")) {
            String[] strings = s.split(":");
            map.put(strings[0], strings[1]);
        }
        return map;
    }

    public static String solve(String ruleStr, List<String> data) {
        int i = 0;
        String pattern = "\\{[^}]*\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(ruleStr);
        while (m.find()) {
            ruleStr = ruleStr.replaceFirst("\\{[^}]*\\}", data.get(i));
            ++i;
        }
        return ruleStr;
    }

    public static List<String> solveList(String ruleStr, List<String> data) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String pattern = "\\{[^}]*\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(ruleStr);
        while (m.find()) {
            ruleStr = ruleStr.replaceFirst("\\{[^}]*\\}", data.get(i));
            result.add(ruleStr);
            ++i;
        }
        return result;
    }
}

