/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.webhelp.util;

import com.haiyisoft.ep.exception.FrameworkException;
import com.haiyisoft.ep.framework.util.ApplicationUtil;
import com.haiyisoft.ep.framework.webhelp.model.HelpFrame;
import com.haiyisoft.ep.framework.webhelp.model.SearchResultBean;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class WebHelpUtil {
    private static WebHelpUtil me = null;
    private HelpFrame webHelpRoot;

    private WebHelpUtil() {
    }

    public HelpFrame getWebHelpRoot() {
        return this.webHelpRoot;
    }

    public void setWebHelpRoot(HelpFrame webHelpRoot) {
        this.webHelpRoot = webHelpRoot;
    }

    public static WebHelpUtil getInstance() {
        if (me == null) {
            me = new WebHelpUtil();
        }
        return me;
    }

    public List<SearchResultBean> retrieveSearchIndex(String searchContent) {
        ArrayList<SearchResultBean> list = new ArrayList<SearchResultBean>();
        String helpIndexPath = ApplicationUtil.getAppConfig().getWebHelpIndexPath();
        try {
            FSDirectory fsDirectory = FSDirectory.open((File)new File(helpIndexPath));
            IndexReader reader = null;
            try {
                reader = IndexReader.open((Directory)fsDirectory);
            }
            catch (Exception e) {
                new FrameworkException("\u6253\u5f00\u7d22\u5f15\u76ee\u5f55\u5f02\u5e38", (Throwable)e).handle(true, false);
            }
            IndexSearcher indexSearcher = new IndexSearcher(reader);
            String field = "BODY";
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_32);
            QueryParser queryParser = new QueryParser(Version.LUCENE_32, field, (Analyzer)analyzer);
            Query query = queryParser.parse(searchContent);
            if (query != null && indexSearcher != null) {
                TopDocs hits = indexSearcher.search(query, 10);
                int totalHits = hits.totalHits;
                int len = Math.min(1000, totalHits);
                ScoreDoc[] docs = hits.scoreDocs;
                int i = 0;
                while (i < len) {
                    SearchResultBean info = new SearchResultBean();
                    Document doc = indexSearcher.doc(docs[i].doc);
                    info.setTitle(doc.get("TITLE"));
                    info.setLinkUrl(doc.get("LINK_URL"));
                    info.setTopic(doc.get("TOPIC"));
                    list.add(info);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

