/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.webhelp.util;

import com.haiyisoft.ep.framework.webhelp.model.FunctionHelp;
import com.haiyisoft.ep.framework.webhelp.model.HelpFrame;
import com.haiyisoft.ep.framework.webhelp.model.ModuleHelpModel;
import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class ModuleParser
extends DefaultHandler {
    private HelpFrame rootHelp;
    private ModuleHelpModel moduler;
    private FunctionHelp functioner;
    private CharArrayWriter contents = new CharArrayWriter();
    private List<FunctionHelp> functionList;

    ModuleParser() {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.contents.write(ch, start, length);
    }

    @Override
    public void startElement(String nameSpaceURI, String name, String qName, Attributes atts) {
        this.contents.reset();
        if ("functionList".equals(name)) {
            if (this.moduler.getFunctionList() == null) {
                this.functionList = new ArrayList<FunctionHelp>();
                this.moduler.setFunctionList(this.functionList);
            } else {
                this.functionList = this.moduler.getFunctionList();
            }
        } else if ("function".equals(name)) {
            FunctionHelp func = new FunctionHelp();
            func.setDescription(atts.getValue("name"));
            func.setHelpFile(atts.getValue("url"));
            func.setIndex(atts.getValue("index"));
            func.setModuleIndex(this.moduler.getIndex());
            if (this.functioner != null) {
                this.functioner.getChildren().add(func);
                func.setParent(this.functioner);
            }
            this.functioner = func;
        }
    }

    @Override
    public void endElement(String nameSapceURI, String name, String qName) {
        if ("function".equals(name)) {
            if (StringUtils.isNotEmpty((String)this.functioner.getIndex())) {
                this.rootHelp.getFunctionMap().put(this.functioner.getIndex(), this.functioner);
            } else {
                this.rootHelp.getFunctionMap().put("" + this.functioner.hashCode(), this.functioner);
            }
            if (this.functioner.getParent() == null) {
                this.functionList.add(this.functioner);
            }
            this.functioner = this.functioner.getParent();
        }
    }

    public void setModuler(ModuleHelpModel moduler) {
        this.moduler = moduler;
    }

    public void setRootHelp(HelpFrame rootHelp) {
        this.rootHelp = rootHelp;
    }

    public HelpFrame getRootHelp() {
        return this.rootHelp;
    }
}

