/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.webhelp.util;

import com.haiyisoft.ep.exception.BaseRunException;
import com.haiyisoft.ep.framework.model.ITreeRetriever;
import com.haiyisoft.ep.framework.model.TreeBean;
import com.haiyisoft.ep.framework.webhelp.model.FunctionHelp;
import com.haiyisoft.ep.framework.webhelp.model.HelpFrame;
import com.haiyisoft.ep.framework.webhelp.model.ModuleHelpModel;
import com.haiyisoft.ep.framework.webhelp.util.WebHelpUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HelpIndexTreeRetriever
implements ITreeRetriever {
    public TreeBean createTree(String rootCode) {
        TreeBean treeBean = new TreeBean();
        treeBean.setType("Root");
        treeBean.setLabel("\u6839\u8282\u70b9");
        treeBean.setCode("Root");
        return treeBean;
    }

    public List<TreeBean> retrieveNode(TreeBean treeBean) {
        String nodeType = treeBean.getType();
        String rootNode = treeBean.getCode();
        ArrayList<TreeBean> nodeList = new ArrayList<TreeBean>();
        try {
            if ("Root".equals(nodeType)) {
                HelpFrame helpFrame = WebHelpUtil.getInstance().getWebHelpRoot();
                int x = 0;
                while (x < helpFrame.getModuleHelpList().size()) {
                    ModuleHelpModel module = helpFrame.getModuleHelpList().get(x);
                    TreeBean bean = new TreeBean();
                    bean.setCode(module.getIndex());
                    bean.setLabel(module.getDescription());
                    bean.setType("ModuleIndex");
                    nodeList.add(bean);
                    ++x;
                }
            } else if ("ModuleIndex".equals(nodeType)) {
                ModuleHelpModel helpModule = this.getSelectedHelpModule(rootNode);
                int x = 0;
                while (x < helpModule.getFunctionList().size()) {
                    FunctionHelp func = helpModule.getFunctionList().get(x);
                    TreeBean node = new TreeBean();
                    node.setLabel(func.getDescription());
                    if (StringUtils.isNotEmpty((String)func.getIndex())) {
                        node.setCode(func.getIndex());
                        node.setLocation("../webhelp/helpcontent.jsp?helpFileName=webhelp/" + func.getHelpFile() + "&helpIndex=" + func.getIndex());
                    } else {
                        node.setCode("" + func.hashCode());
                    }
                    node.setType("FunctionIndex");
                    nodeList.add(node);
                    ++x;
                }
            } else if ("FunctionIndex".equals(nodeType)) {
                FunctionHelp parentFunc = WebHelpUtil.getInstance().getWebHelpRoot().getFunctionMap().get(rootNode);
                int x = 0;
                while (x < parentFunc.getChildren().size()) {
                    FunctionHelp func = parentFunc.getChildren().get(x);
                    TreeBean node = new TreeBean();
                    if (StringUtils.isNotEmpty((String)func.getIndex())) {
                        node.setCode(func.getIndex());
                        node.setLocation("../webhelp/helpcontent.jsp?helpFileName=webhelp/" + func.getHelpFile() + "&helpIndex=" + func.getIndex());
                    } else {
                        node.setCode("" + func.hashCode());
                    }
                    node.setLabel(func.getDescription());
                    node.setType("FunctionIndex");
                    nodeList.add(node);
                    ++x;
                }
            }
        }
        catch (Exception ex) {
            new BaseRunException("\u6784\u9020\u8054\u673a\u5e2e\u52a9\u6811\u51fa\u9519!", (Throwable)ex).handle();
        }
        return nodeList;
    }

    public boolean hasChild(TreeBean treeBean) {
        String nodeType = treeBean.getType();
        if ("Root".equals(nodeType) || "ModuleIndex".equals(nodeType)) {
            return true;
        }
        if ("FunctionIndex".equals(nodeType)) {
            FunctionHelp parentFunc = WebHelpUtil.getInstance().getWebHelpRoot().getFunctionMap().get(treeBean.getCode());
            return parentFunc.getChildren().size() > 0;
        }
        return false;
    }

    private ModuleHelpModel getSelectedHelpModule(String rootNode) throws Exception {
        ModuleHelpModel helpModule = null;
        HelpFrame helpFrame = WebHelpUtil.getInstance().getWebHelpRoot();
        int x = 0;
        while (x < helpFrame.getModuleHelpList().size()) {
            ModuleHelpModel module = helpFrame.getModuleHelpList().get(x);
            if (rootNode.equals(module.getIndex())) {
                helpModule = module;
                break;
            }
            ++x;
        }
        return helpModule;
    }
}

