/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.webaction;

import com.emms.framework.util.CommonService;
import com.haiyisoft.ep.exception.FrameworkException;
import com.haiyisoft.ep.framework.exception.BizServiceException;
import com.haiyisoft.ep.framework.listener.SessionListener;
import com.haiyisoft.ep.framework.login.security.RSAKeyService;
import com.haiyisoft.ep.framework.login.security.RSAKeyWrap;
import com.haiyisoft.ep.framework.model.LoginBean;
import com.haiyisoft.ep.framework.model.RemoteClient;
import com.haiyisoft.ep.framework.ui.struts2.action.DispatchAction;
import com.haiyisoft.ep.framework.util.ApplicationUtil;
import com.haiyisoft.ep.framework.view.UserView;
import com.haiyisoft.ep.log.LogUtil;
import com.haiyisoft.support.exception.ServicePromptException;
import com.opensymphony.xwork2.ModelDriven;
import com.sgcc.isc.ualogin.client.util.ISCAuthRouteSettings;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.SessionAware;

public class LoginAction
extends DispatchAction
implements SessionAware,
ServletRequestAware,
ModelDriven<LoginBean> {
    private static final String F5_PROXY_KEYWORD = "F5_PROXY_KEYWORD";
    private static final String ARRAY_PROXY_KEYWORD = "X-Forwarded-For";
    protected static final String CHANGE_PWD = "changepwd";
    protected static final String CUSTOM_FORWORD = "other";
    protected static final String REPEAT_LOGIN = "repeatLogin";
    protected String forward;
    private String fullScreenFlag;
    private String encryptLoginInfo;
    private static Log logger = LogUtil.getFrameworkLoger();
    private static final long serialVersionUID = 1L;
    private Map<String, Object> sessionMap;
    protected HttpServletRequest request;
    protected String sessionKey;
    protected LoginBean loginBean;

    public String getEncryptLoginInfo() {
        return this.encryptLoginInfo;
    }

    public void setEncryptLoginInfo(String encryptLoginInfo) {
        this.encryptLoginInfo = encryptLoginInfo;
    }

    public String getFullScreenFlag() {
        return this.fullScreenFlag;
    }

    public void setFullScreenFlag(String fullScreenFlag) {
        this.fullScreenFlag = fullScreenFlag;
    }

    public String getMainPage() {
        String url = "";
        Map typeMap = ApplicationUtil.getAppConfig().getAppExtProp();
        url = typeMap.get("homePageUrl") != null && !"".equals(typeMap.get("homePageUrl")) ? (String)typeMap.get("homePageUrl") : ApplicationUtil.getAppConfig().getHomePageUrl();
        return url;
    }

    private void initLoginBean() {
        this.loginBean = new LoginBean();
    }

    @Override
    public String init() {
        try {
            String result = this.beforeLogin();
            if (result != null) {
                return result;
            }
            this.doLogin();
            result = this.afterLogin();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            String msg4A = e.getMessage();
            if (e instanceof BizServiceException || e instanceof ServicePromptException) {
                super.addActionError(e.getMessage());
            } else {
                super.addActionError("\u767b\u5f55\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
                logger.error((Object)("\u767b\u5f55\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
            }
            if (this.isAuthenticateBy4A()) {
                msg4A = "\u8d26\u53f7\u57284A\u670d\u52a1\u5668\u9a8c\u8bc1\u6210\u529f\uff0c\u4f46\u5728\u8425\u9500\u7cfb\u7edf\u9a8c\u8bc1\u5931\u8d25!<br/>\u5177\u4f53\u539f\u56e0:" + msg4A;
                this.request.getSession().setAttribute("error4A", (Object)msg4A);
                this.forward = "/error.jsp";
                return "forward";
            }
            return "input";
        }
        if ("on".equals(this.fullScreenFlag)) {
            return "maxscreen";
        }
        return "success";
    }

    private boolean isAuthenticateBy4A() {
        Object obj = this.request.getSession().getServletContext().getAttribute("iscAuthPower");
        if (obj == null) {
            obj = ISCAuthRouteSettings.ISC_AUTH_POWER_OFF;
        }
        String power = (String)obj;
        return ISCAuthRouteSettings.ISC_AUTH_POWER_ON.equals(power);
    }

    protected String beforeLogin() {
        String forbidRepeatedLogin;
        String sessionKey;
        LoginBean bean;
        String validateCodeString = this.request.getParameter("validateCode");
        Object sessionCode = this.sessionMap.get("loginValidateCode");
        if (!(sessionCode == null || validateCodeString != null && validateCodeString.toLowerCase().equals(sessionCode))) {
            this.addFieldError("validateCode", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
            return "input";
        }
        if ("true".equals(ApplicationUtil.getAppConfig().getExtProp().get("encryptLogin"))) {
            this.getModel();
            if (this.loginBean instanceof LoginBean && this.encryptLoginInfo != null) {
                RSAKeyWrap keyPair = (RSAKeyWrap)this.sessionMap.get("RSAKeyWrap");
                try {
                    String orginLoginInfo = RSAKeyService.getInstance().decryptJsValue(keyPair, this.encryptLoginInfo);
                    String[] infoArray = orginLoginInfo.split(";;");
                    bean = this.loginBean;
                    if (infoArray != null && infoArray.length > 0) {
                        bean.setIdentity(infoArray[0]);
                    }
                    if (infoArray.length > 1) {
                        bean.setTicket(infoArray[1]);
                    }
                }
                catch (Exception e) {
                    new FrameworkException("\u89e3\u6790\u767b\u5f55\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e).handle();
                }
            }
        }
        if ((sessionKey = this.request.getParameter("sessionKey")) != null && "true".equals(forbidRepeatedLogin = ApplicationUtil.getAppConfig().getExtProp("forbidRepeatedLogin"))) {
            Object sessionKeyValue = this.request.getSession(true).getAttribute(sessionKey);
            bean = this.loginBean;
            String loginCode = bean.getIdentity();
            UserView userview = (UserView)this.request.getSession().getAttribute("UserView");
            if (userview != null && sessionKeyValue == null && !userview.getLoginCode().equals(loginCode)) {
                this.addActionError("\u540c\u4e00\u5ba2\u6237\u7aef\u4e0d\u5141\u8bb8\u767b\u5f55\u591a\u4e2a\u8d26\u53f7\uff01");
                return "input";
            }
        }
        if (ApplicationUtil.getAppConfig().isPerformDistinctSignin() && CommonService.isRepeatLogin((String)this.loginBean.getIdentity())) {
            this.addActionError("\u540c\u4e00\u8d26\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d\u767b\u5f55\uff01");
            return "input";
        }
        return null;
    }

    protected String afterLogin() {
        return null;
    }

    public void setSession(Map<String, Object> asession) {
        this.sessionMap = asession;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected void doLogin() throws Exception {
        RemoteClient clientInfo = this.genClientInfo();
        this.authenticate(this.loginBean, clientInfo);
        HttpSession httpsession = this.request.getSession(true);
        UserView userView = this.createUserView(this.loginBean.getIdentity(), clientInfo);
        userView.setLoginCode(this.loginBean.getIdentity());
        httpsession.setAttribute("UserView", (Object)userView);
        String forbidRepeatedLogin = ApplicationUtil.getAppConfig().getExtProp("forbidRepeatedLogin");
        if ("true".equals(forbidRepeatedLogin) && this.sessionKey != null) {
            httpsession.setAttribute(this.sessionKey, (Object)this.sessionKey);
        }
        SessionListener sessionListener = new SessionListener(userView, httpsession.getId());
        httpsession.setAttribute("listener", (Object)sessionListener);
    }

    protected void authenticate(LoginBean loginBean, RemoteClient clientInfo) throws Exception {
    }

    protected UserView createUserView(String loginCode, RemoteClient clientInfo) {
        UserView userView = new UserView();
        userView.initViewDat(loginCode);
        userView.setIpAddress(clientInfo.getIpAddress());
        userView.setComputerName(clientInfo.getComputerName());
        userView.setSessionID(clientInfo.getSession().getId());
        return userView;
    }

    public LoginBean getModel() {
        if (this.loginBean == null) {
            this.initLoginBean();
        }
        return this.loginBean;
    }

    protected RemoteClient genClientInfo() {
        String proxyIp;
        RemoteClient clientInfo = new RemoteClient();
        String ip = this.request.getRemoteAddr();
        if (this.request.getHeader(F5_PROXY_KEYWORD) != null) {
            proxyIp = this.request.getHeader(F5_PROXY_KEYWORD);
            if (proxyIp.trim().length() > 0) {
                ip = proxyIp;
            }
        } else if (this.request.getHeader(ARRAY_PROXY_KEYWORD) != null && (proxyIp = this.request.getHeader(ARRAY_PROXY_KEYWORD)).trim().length() > 0) {
            ip = proxyIp;
        }
        clientInfo.setIpAddress(ip);
        clientInfo.setComputerName(this.request.getRemoteHost());
        HttpSession httpsession = this.request.getSession(true);
        clientInfo.setSessionId(httpsession.getId());
        clientInfo.setSession(httpsession);
        return clientInfo;
    }

    public String getForward() {
        return this.forward;
    }

    public void setForward(String forward) {
        this.forward = forward;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }
}

