/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.webaction;

import com.emms.framework.util.PersonalDataUtil;
import com.haiyisoft.ep.common.util.CommonUtil;
import com.haiyisoft.ep.framework.model.MenuItem;
import com.haiyisoft.ep.framework.util.AssistMapUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.SessionAware;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Namespace(value="/framework")
@ParentPackage(value="framework-default")
@Action(value="funcLocator", results={@Result(name={"success"}, type="xml", location="content")})
public class FuncLocatorAction
extends ActionSupport
implements ParameterAware,
SessionAware {
    private static final long serialVersionUID = -4418458307681869830L;
    private Map<String, String[]> parameters;
    private Map<String, Object> session;
    private String content;

    public void setParameters(Map<String, String[]> arg0) {
        this.parameters = arg0;
    }

    public String execute() throws Exception {
        String shortName = null;
        if (this.parameters.get("_SHORT_NAME_") != null && this.parameters.get("_SHORT_NAME_").length > 0) {
            shortName = this.parameters.get("_SHORT_NAME_")[0];
        }
        if (shortName != null) {
            List menuList = (List)this.session.get("AJAX_MENU_LIST");
            Boolean refreshFlag = (Boolean)this.session.get("__funcLocatorRefresh");
            if (menuList == null || refreshFlag.booleanValue()) {
                menuList = PersonalDataUtil.getOperatorRightItems();
                this.session.put("AJAX_MENU_LIST", menuList);
                this.session.put("__funcLocatorRefresh", false);
            }
            shortName = URLDecoder.decode(shortName, "UTF-8");
            List<MenuItem> filterList = this.filterRightItem(menuList, shortName);
            this.content = this.getFilterFunctionString(filterList);
        }
        return "success";
    }

    private String getFilterFunctionString(List<MenuItem> funcList) {
        String filterString = "";
        try {
            Element funcRoot;
            DocumentImpl dom = new DocumentImpl();
            Element root = funcRoot = dom.createElement("funclist");
            int x = 0;
            while (x < funcList.size()) {
                MenuItem item = funcList.get(x);
                Element funcItem = dom.createElement("function");
                funcItem.setAttribute("code", item.getCode());
                funcItem.setAttribute("name", item.getName());
                funcItem.setAttribute("icon", item.getImage());
                funcItem.setAttribute("url", item.getEntity());
                root.appendChild(funcItem);
                ++x;
            }
            dom.appendChild(funcRoot);
            filterString = CommonUtil.getStrFromXml((Document)dom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filterString;
    }

    private boolean isFilterByName(String shortName) {
        String regex = "[\u4e00-\u9fa5]";
        int i = 0;
        while (i < shortName.length()) {
            String s = "" + shortName.charAt(i);
            if (s.matches(regex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List<MenuItem> filterRightItem(List<MenuItem> ownList, String shortName) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        if (ownList == null) {
            return result;
        }
        boolean useType = this.isFilterByName(shortName);
        if (!useType) {
            shortName = shortName.toUpperCase();
        }
        int x = 0;
        while (x < ownList.size()) {
            MenuItem item = ownList.get(x);
            String itemName = item.getName();
            if (itemName != null) {
                if (useType) {
                    if (item.getName().indexOf(shortName) > -1) {
                        result.add(item);
                    }
                } else if (AssistMapUtil.getInstance().getPinyin(itemName).indexOf(shortName) > -1) {
                    result.add(item);
                }
            }
            ++x;
        }
        return result;
    }

    public void setSession(Map<String, Object> arg0) {
        this.session = arg0;
    }

    public String getContent() {
        return this.content;
    }
}

