/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.model;

import com.haiyisoft.ep.exception.BaseRunException;
import com.haiyisoft.ep.framework.ui.struts2.model.AjaxDataWrap;
import com.haiyisoft.ep.framework.util.XssUtil;
import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.errors.EncodingException;

public class DataCenter {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, AjaxDataWrap> dataWraps = new HashMap<String, AjaxDataWrap>();
    private String errorMessage = "";
    private String message = "";

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = this.escapeEncode(errorMessage, 2);
    }

    public String getParameter(String parameter) {
        return this.parameters.get(parameter);
    }

    public void setParameter(String parameter, String value) {
        this.parameters.put(parameter, value);
    }

    public void setParameter(String parameter, String value, int escapeType) {
        this.parameters.put(parameter, this.escapeEncode(value, escapeType));
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setParameters(Map<String, String> parameters, int escapeType) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            entry.setValue(this.escapeEncode(entry.getValue(), escapeType));
        }
        this.parameters = parameters;
    }

    public void setAjaxDataWrap(String dataWrapName, AjaxDataWrap dataWrap) {
        this.dataWraps.put(dataWrapName, dataWrap);
    }

    public AjaxDataWrap getAjaxDataWrap(String dataWrapName) {
        return this.dataWraps.get(dataWrapName);
    }

    public Map<String, AjaxDataWrap> getDataWraps() {
        return this.dataWraps;
    }

    public void setDataWraps(Map<String, AjaxDataWrap> dataWraps) {
        this.dataWraps = dataWraps;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessage(String message, int escapeType) {
        this.message = this.escapeEncode(message, escapeType);
    }

    private String escapeEncode(String input, int escapeType) {
        String output = input;
        switch (escapeType) {
            case 0: {
                output = XssUtil.encodeForHTML((String)input);
                break;
            }
            case 1: {
                output = XssUtil.encodeForHTMLAttribute((String)input);
                break;
            }
            case 2: {
                output = XssUtil.encodeForJavaScript((String)input);
                break;
            }
            case 3: {
                output = XssUtil.encodeForCSS((String)input);
                break;
            }
            case 4: {
                try {
                    output = XssUtil.encodeForURL((String)input);
                    break;
                }
                catch (EncodingException e) {
                    throw new BaseRunException((Throwable)e);
                }
            }
        }
        return output;
    }
}

