/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.model;

import com.haiyisoft.ep.common.db.DataSetUtil;
import com.haiyisoft.ep.common.db.Record;
import com.haiyisoft.ep.common.db.dataset.ClientDataSet;
import com.haiyisoft.ep.common.model.FieldMetaData;
import com.haiyisoft.ep.common.model.QueryParam;
import com.haiyisoft.ep.common.model.QueryParamList;
import com.haiyisoft.ep.exception.FrameworkException;
import com.haiyisoft.ep.framework.ui.struts2.BeanActionUtil;
import com.haiyisoft.ep.framework.ui.struts2.model.DataSetWrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientDataSetWrap
extends DataSetWrap<Record> {
    private String dsName;

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
        if (dsName != null && this.dataSet == null) {
            this.dataSet = DataSetUtil.createClientDataSet((String)dsName);
            this.dataSet.setCacheFlag(true);
        }
    }

    public List<Record> getDataList() {
        return this.getClientDataSet().getDataList();
    }

    public void setDataList(List<Record> dataList) {
        this.getClientDataSet().setDataList(dataList);
    }

    public ClientDataSet getClientDataSet() {
        if (this.dataSet == null) {
            new FrameworkException("\u7ed3\u679c\u96c6\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\u5f53\u524d\u6570\u636e\u96c6\u540d\u79f0\u4e3a\uff1a" + this.dsName + "\uff0c\u8bf7\u68c0\u67e5\uff01").handle();
        }
        return (ClientDataSet)this.dataSet;
    }

    public void executeQuery(Object[] params, boolean pageMode) {
        this.handleQueryParam();
        this.handleSortParam();
        this.getClientDataSet().setPageMode(pageMode);
        this.getClientDataSet().setPageInfo(this.pageInfo);
        this.getClientDataSet().executeQuery(params);
        this.pageInfo = this.getClientDataSet().getPageInfo();
    }

    private void handleSortParam() {
        if (this.getSortString() != null && this.getSortString().length() > 0) {
            this.getClientDataSet().appendSortStatement("ORDER BY " + this.getSortString());
        }
    }

    private void handleQueryParam() {
        List<? extends FieldMetaData> metaDataList = this.getMetaData();
        QueryParamList paramList = BeanActionUtil.getQueryParam(metaDataList, this.query);
        if (paramList == null) {
            return;
        }
        StringBuilder where = new StringBuilder();
        ArrayList<Object> paramValue = new ArrayList<Object>();
        List list = paramList.getParams();
        for (QueryParam q : list) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(q.getName());
            where.append(" ");
            where.append(q.getRelation());
            where.append(" ?");
            paramValue.add(q.getValue());
        }
        this.getClientDataSet().appendWhereStatement(where.toString(), paramValue);
    }

    public List<? extends FieldMetaData> getMetaData() {
        if (this.dsName != null) {
            return DataSetUtil.getDataSetMetaData((String)this.dsName);
        }
        return new ArrayList();
    }

    public void update() {
        this.getClientDataSet().update();
    }

    public void add() {
        this.getClientDataSet().addRecord();
    }

    public void remove() {
        List<Record> list = this.getDataList();
        if (list == null) {
            return;
        }
        List<Record> removedRecords = this.getSelectedRecord();
        for (Record r : removedRecords) {
            this.getClientDataSet().removeRecordByRowID(r.getInt("rowID"));
        }
    }

    public List<Record> getSelectedRecord() {
        ArrayList<Record> result = new ArrayList<Record>();
        List<Record> list = this.getDataList();
        if (list != null) {
            for (Record r : list) {
                if (!"1".equals(r.get("checked"))) continue;
                result.add(r);
            }
        }
        return result;
    }

    public void prepare(String dwName, int dataSize, Map<String, Object> parameters, Class<Record> elementClass) {
        String[] dsNames = (String[])parameters.get(String.valueOf(dwName) + ".dsName");
        if (dsNames == null || dsNames.length <= 0) {
            return;
        }
        this.setDsName(dsNames[0]);
        int i = 0;
        while (i < dataSize) {
            this.getClientDataSet().addRecord();
            ++i;
        }
    }
}

